/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.events;

/**
 *  Event listeners can be registered using 
 * <code>Event.addEventListenerNS</code> within a group. 
 * <p> When a set of actions associated with event listeners is critical for 
 * an application such as refreshing the display, it is important to 
 * separate them from other event listeners who might stop the event flow. 
 * In order to prevent undesirable side effects, the application should 
 * create a group using <code>DocumentEvent.createEventListenerGroup</code> 
 * and use it when adding or removing event listeners. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030221'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface EventListenerGroup {
    /**
     *  This method checks if the supplied <code>EventListenerGroup</code> is 
     * the same as the <code>EventListenerGroup</code> upon which the method 
     * is called. 
     * @param other  The <code>EventListenerGroup</code> with which to check 
     *   equality. 
     * @return  Returns <code>true</code> if the 
     *   <code>EventListenerGroup</code>s are the same, else returns 
     *   <code>false</code>.  We should clarify what "equal" means here, or 
     *   better yet, substitute it with "is the same"? 
     */
    public boolean isSameEventListenerGroup(EventListenerGroup other);

}
