<!-- ....................................................................... -->
<!-- XHTML Events Qname Module  ............................................ -->
<!-- file: xhtml-events-qname-1.mod

     This is XHTML Events - the Events Module for XHTML and Friends,
	 a redefinition of access to the DOM events model.

     Copyright 2000-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ENTITIES XHTML Events Qnames 1.0//EN"
       SYSTEM "http://www.w3.org/TR/xhtml-events/DTD/xhtml-events-qname-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Xevengts Qname (Qualified Name) Module

     This module is contained in two parts, labeled Section 'A' and 'B':

       Section A declares parameter entities to support namespace-
       qualified names, namespace declarations, and name prefixing
       for XHTML Events and extensions.

       Section B declares parameter entities used to provide
       namespace-qualified names for all XHTML Events element types:

         %action.qname;   the xmlns-qualified name for <action>
         %onevent.qname;     the xmlns-qualified name for <onevent>
         ...

     XHTML Events extensions would create a module similar to this one.
     Included in the XHTML distribution is a template module
     ('template-qname-1.mod') suitable for this purpose.
-->

<!-- Section A: XHTML Events XML Namespace Framework :::::::::::::::::::: -->

<!-- 1. Declare a %XHTML-EVENTS.prefixed; conditional section keyword, used
        to activate namespace prefixing. The default value should
        inherit '%NS.prefixed;' from the DTD driver, so that unless
        overridden, the default behaviour follows the overall DTD
        prefixing scheme.
-->
<!ENTITY % NS.prefixed "IGNORE" >
<!ENTITY % XHTML-EVENTS.prefixed "%NS.prefixed;" >

<!-- 2. Declare a parameter entity (eg., %XHTML.xmlns;) containing
        the URI reference used to identify the XHTML namespace:
		We hope that this namespace will change to something unique to XHTML
		in the near future.
-->
<!ENTITY % XHTML-EVENTS.xmlns  "http://www.w3.org/1999/xhtml" >

<!-- 3. Declare parameter entities (eg., %XHTML.prefix;) containing
        the default namespace prefix string(s) to use when prefixing
        is enabled. This may be overridden in the DTD driver or the
        internal subset of an document instance. If no default prefix
        is desired, this may be declared as an empty string.

     NOTE: As specified in [XMLNAMES], the namespace prefix serves
     as a proxy for the URI reference, and is not in itself significant.
-->
<!ENTITY % XHTML-EVENTS.prefix  "" >

<!-- 4. Declare parameter entities (eg., %XHTML.pfx;) containing the
        colonized prefix(es) (eg., '%XHTML.prefix;:') used when
        prefixing is active, an empty string when it is not.
-->
<![%XHTML-EVENTS.prefixed;[
<!ENTITY % XHTML-EVENTS.pfx  "%XHTML-EVENTS.prefix;:" >
]]>
<!ENTITY % XHTML-EVENTS.pfx  "" >

<!-- declare qualified name extensions here ............ -->
<!ENTITY % xhtml-qname-extra.mod "" >
%xhtml-qname-extra.mod;

<!-- 5. The parameter entity %XHTML.xmlns.extra.attrib; may be
        redeclared to contain any non-XHTML namespace declaration
        attributes for namespaces embedded in XHTML. The default
        is an empty string.  XLink should be included here if used
        in the DTD.
-->
<!ENTITY % XHTML-EVENTS.xmlns.extra.attrib "" >


<!-- Section B: XHTML Qualified Names ::::::::::::::::::::::::::::: -->

<!-- 6. This section declares parameter entities used to provide
        namespace-qualified names for all XHTML element types.
-->

<!-- module:  xhtml-events-basic-1.mod -->

<!ENTITY % xhtml-events.onevent.qname  "%XHTML-EVENTS.pfx;onevent" >
<!ENTITY % xhtml-events.action.qname  "%XHTML-EVENTS.pfx;action" >
<!ENTITY % xhtml-events.do.qname  "%XHTML-EVENTS.pfx;do" >
<!ENTITY % xhtml-events.stopevent.qname  "%XHTML-EVENTS.pfx;stopevent" >

<!-- end of xhtml-events-qname-1.mod -->
