/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.xpath;

import org.w3c.dom.Node;

/**
 * The <code>XPathSetSnapshot</code> interface lists the node set resulting 
 * from an evaluation of an XPath expression as a static list that is not 
 * invalidated or changed by document mutation.
 * <p>The individual nodes of a <code>XPathSetSnapshot</code> may be 
 * manipulated in the hierarchy and these changes are seen immediately by 
 * users referencing the nodes through the snapshot.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-XPath-20011031'>Document Object Model (DOM) Level 3 XPath Specification</a>.
 */
public interface XPathSetSnapshot {
    /**
     * Returns the <code>index</code>th item in the collection. If 
     * <code>index</code> is greater than or equal to the number of nodes in 
     * the list, this method returns <code>null</code>.
     * @param index Index into the collection.
     * @return The node at the <code>index</code>th position in the 
     *   <code>NodeList</code>, or <code>null</code> if that is not a valid 
     *   index.
     */
    public Node item(int index);

    /**
     * The number of nodes in the list. The range of valid child node indices 
     * is <code>0</code> to <code>length-1</code> inclusive.
     */
    public int getLength();

}
