/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.xpath;

import org.w3c.dom.Node;
import org.w3c.dom.DOMException;

/**
 * The <code>XPathSetIterator</code> interface iterates the node set resulting 
 * from evaluation of an XPath expression.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-XPath-20011031'>Document Object Model (DOM) Level 3 XPath Specification</a>.
 */
public interface XPathSetIterator {
    /**
     * Returns the next node from the <code>XPathResult</code> node set. If 
     * there are no more nodes in the set to be returned by the iterator, 
     * this method returns <code>null</code>.
     * @return Returns the next node.
     * @exception DOMException
     *   INVALID_STATE_ERR: The document has been mutated since the node set 
     *   result was returned.
     */
    public Node nextNode()
                         throws DOMException;

}
