/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.xpath;

/**
 * The <code>NamespaceResolver</code> interface permit <code>prefix</code> 
 * strings in the expression to be properly bound to 
 * <code>namespaceURI</code> strings. The expectation is that an instance of 
 * the <code>NamespaceResolver</code> interface can be obtained by using 
 * binding-specific casting methods on an instance of the 
 * <code>Element</code> interface. This interface may also be user 
 * implemented instead of obtaining the implementation from an 
 * <code>Element</code>.This interface should be reconciled with the core 
 * method for namespace resolution so that it is automatically implemented 
 * by any ElementThe current proposal matches the definition in the Node 
 * interface.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-XPath-20010618'>Document Object Model (DOM) Level 3 XPath Specification</a>.
 */
public interface NamespaceResolver {
    /**
     * Look up the namespace URI associated to the given prefix, starting from 
     * this node.
     * @param prefix The prefix to look for.
     * @return Returns the associated namespace URI or <code>null</code> if 
     *   none is found.
     */
    public String lookupNamespaceURI(String prefix);

}
