/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

import org.w3c.dom.views.AbstractView;

/**
 * The <code>TextEvent</code> interface provides specific contextual 
 * information associated with Text Events. 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Events-20010823'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface TextEvent extends UIEvent {
    // VirtualKeyCode
    /**
     * Used for key events which do not have a virtual key code available.
     */
    public static final int DOM_VK_UNDEFINED          = 0x0;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_RIGHT_ALT          = 0x01;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_LEFT_ALT           = 0x02;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_LEFT_CONTROL       = 0x03;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_RIGHT_CONTROL      = 0x04;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_LEFT_SHIFT         = 0x05;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_RIGHT_SHIFT        = 0x06;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_LEFT_META          = 0x07;
    /**
     * This key is a modifier key
     */
    public static final int DOM_VK_RIGHT_META         = 0x08;
    /**
     */
    public static final int DOM_VK_CAPS_LOCK          = 0x09;
    /**
     */
    public static final int DOM_VK_DELETE             = 0x0A;
    /**
     */
    public static final int DOM_VK_END                = 0x0B;
    /**
     */
    public static final int DOM_VK_ENTER              = 0x0C;
    /**
     */
    public static final int DOM_VK_ESCAPE             = 0x0D;
    /**
     */
    public static final int DOM_VK_HOME               = 0x0E;
    /**
     */
    public static final int DOM_VK_INSERT             = 0x0F;
    /**
     */
    public static final int DOM_VK_NUM_LOCK           = 0x10;
    /**
     */
    public static final int DOM_VK_PAUSE              = 0x11;
    /**
     */
    public static final int DOM_VK_PRINTSCREEN        = 0x12;
    /**
     */
    public static final int DOM_VK_SCROLL_LOCK        = 0x13;
    /**
     */
    public static final int DOM_VK_LEFT               = 0x14;
    /**
     */
    public static final int DOM_VK_RIGHT              = 0x15;
    /**
     */
    public static final int DOM_VK_UP                 = 0x16;
    /**
     */
    public static final int DOM_VK_DOWN               = 0x17;
    /**
     */
    public static final int DOM_VK_PAGE_DOWN          = 0x18;
    /**
     */
    public static final int DOM_VK_PAGE_UP            = 0x19;
    /**
     * Constant for the F1 function key.
     */
    public static final int DOM_VK_F1                 = 0x1A;
    /**
     * Constant for the F2 function key.
     */
    public static final int DOM_VK_F2                 = 0x1B;
    /**
     * Constant for the F3 function key.
     */
    public static final int DOM_VK_F3                 = 0x1C;
    /**
     * Constant for the F4 function key.
     */
    public static final int DOM_VK_F4                 = 0x1D;
    /**
     * Constant for the F5 function key.
     */
    public static final int DOM_VK_F5                 = 0x1E;
    /**
     * Constant for the F6 function key.
     */
    public static final int DOM_VK_F6                 = 0x1F;
    /**
     * Constant for the F7 function key.
     */
    public static final int DOM_VK_F7                 = 0x20;
    /**
     * Constant for the F8 function key.
     */
    public static final int DOM_VK_F8                 = 0x21;
    /**
     * Constant for the F9 function key.
     */
    public static final int DOM_VK_F9                 = 0x22;
    /**
     * Constant for the F10 function key.
     */
    public static final int DOM_VK_F10                = 0x23;
    /**
     * Constant for the F11 function key.
     */
    public static final int DOM_VK_F11                = 0x24;
    /**
     * Constant for the F12 function key.
     */
    public static final int DOM_VK_F12                = 0x25;
    /**
     * Constant for the F13 function key.
     */
    public static final int DOM_VK_F13                = 0x26;
    /**
     * Constant for the F14 function key.
     */
    public static final int DOM_VK_F14                = 0x27;
    /**
     * Constant for the F15 function key.
     */
    public static final int DOM_VK_F15                = 0x28;
    /**
     * Constant for the F16 function key.
     */
    public static final int DOM_VK_F16                = 0x29;
    /**
     * Constant for the F17 function key.
     */
    public static final int DOM_VK_F17                = 0x2A;
    /**
     * Constant for the F18 function key.
     */
    public static final int DOM_VK_F18                = 0x2B;
    /**
     * Constant for the F19 function key.
     */
    public static final int DOM_VK_F19                = 0x2C;
    /**
     * Constant for the F20 function key.
     */
    public static final int DOM_VK_F20                = 0x2D;
    /**
     * Constant for the F21 function key.
     */
    public static final int DOM_VK_F21                = 0x2E;
    /**
     * Constant for the F22 function key.
     */
    public static final int DOM_VK_F22                = 0x2F;
    /**
     * Constant for the F23 function key.
     */
    public static final int DOM_VK_F23                = 0x30;
    /**
     * Constant for the F24 function key.
     */
    public static final int DOM_VK_F24                = 0x31;

    /**
     *  <code>outputString</code> holds the value of the output generated by 
     * the key event. This may be a single Unicode character or it may be a 
     * string. It may also be null in the case where no output was generated 
     * by the key event.
     */
    public String getOutputString();
    /**
     *  <code>outputString</code> holds the value of the output generated by 
     * the key event. This may be a single Unicode character or it may be a 
     * string. It may also be null in the case where no output was generated 
     * by the key event.
     */
    public void setOutputString(String outputString);

    /**
     *  The value of <code>keyVal</code> holds the value of the Unicode 
     * character associated with the depressed key. If the key has no 
     * Unicode representation or no Unicode character is available the value 
     * is 0.. 
     */
    public int getKeyVal();
    /**
     *  The value of <code>keyVal</code> holds the value of the Unicode 
     * character associated with the depressed key. If the key has no 
     * Unicode representation or no Unicode character is available the value 
     * is 0.. 
     */
    public void setKeyVal(int keyVal);

    /**
     * When the key associated with a key event is not representable via a 
     * Unicode character <code>virtKeyVal</code> holds the virtual key code 
     * associated with the depressed key. If the key has a Unicode 
     * representation or no virtual code is available the value is 
     * <code>DOM_VK_UNDEFINED</code>. 
     */
    public int getVirtKeyVal();
    /**
     * When the key associated with a key event is not representable via a 
     * Unicode character <code>virtKeyVal</code> holds the virtual key code 
     * associated with the depressed key. If the key has a Unicode 
     * representation or no virtual code is available the value is 
     * <code>DOM_VK_UNDEFINED</code>. 
     */
    public void setVirtKeyVal(int virtKeyVal);

    /**
     * The <code>visibleOutputGenerated</code> attribute indicates whether the 
     * key event will normally cause visible output. If the key event does 
     * not generate any visible output, such as the use of a function key or 
     * the combination of certain modifier keys used in conjunction with 
     * another key, then the value will be false. If visible output is 
     * normally generated by the key event then the value will be true. 
     * <br>The value of <code>visibleOutputGenerated</code> does not guarantee 
     * the creation of a character. If a key event causing visible output is 
     * cancelable it may be prevented from causing visible output. This 
     * attribute is intended primarily to differentiate between keys events 
     * which may or may not produce visible output depending on the system 
     * state.
     */
    public boolean getVisibleOutputGenerated();
    /**
     * The <code>visibleOutputGenerated</code> attribute indicates whether the 
     * key event will normally cause visible output. If the key event does 
     * not generate any visible output, such as the use of a function key or 
     * the combination of certain modifier keys used in conjunction with 
     * another key, then the value will be false. If visible output is 
     * normally generated by the key event then the value will be true. 
     * <br>The value of <code>visibleOutputGenerated</code> does not guarantee 
     * the creation of a character. If a key event causing visible output is 
     * cancelable it may be prevented from causing visible output. This 
     * attribute is intended primarily to differentiate between keys events 
     * which may or may not produce visible output depending on the system 
     * state.
     */
    public void setVisibleOutputGenerated(boolean visibleOutputGenerated);

    /**
     * The <code>numPad</code> attribute indicates whether or not the key 
     * event was generated on the number pad section of the keyboard. If the 
     * number pad was used to generate the key event the value is true, 
     * otherwise the value is false.
     */
    public boolean getNumPad();
    /**
     * The <code>numPad</code> attribute indicates whether or not the key 
     * event was generated on the number pad section of the keyboard. If the 
     * number pad was used to generate the key event the value is true, 
     * otherwise the value is false.
     */
    public void setNumPad(boolean numPad);

    /**
     * The <code>checkModifier</code> method is used to check the status of a 
     * single modifier key associated with a <code>TextEvent</code>. The 
     * identifier of the modifier in question is passed into the 
     * <code>checkModifier</code> function. If the modifier is triggered it 
     * will return true. If not, it will return false.
     * <br>The list of keys below represents the allowable modifier paramaters 
     * for this method.DOM_VK_LEFT_ALTDOM_VK_RIGHT_ALTDOM_VK_LEFT_CONTROL
     * DOM_VK_RIGHT_CONTROLDOM_VK_LEFT_SHIFTDOM_VK_RIGHT_SHIFTDOM_VK_META
     * @param modifer The modifier which the user wishes to query.
     * @return The status of the modifier represented as a boolean.
     */
    public boolean checkModifier(int modifer);

    /**
     * The <code>initTextEvent</code> method is used to initialize the value 
     * of a <code>TextEvent</code> created through the 
     * <code>DocumentEvent</code> interface. This method may only be called 
     * before the <code>TextEvent</code> has been dispatched via the 
     * dispatchEvent method, though it may be called multiple times during 
     * that phase if necessary. If called multiple times, the final 
     * invocation takes precedence. This method has no effect if called 
     * after the event has been dispatched.
     * @param typeArg Specifies the event type.
     * @param canBubbleArg Specifies whether or not the event can bubble.
     * @param cancelableArg Specifies whether or not the event's default 
     *   action can be prevent.
     * @param viewArg Specifies the <code>TextEvent</code>'s 
     *   <code>AbstractView</code>.
     * @param detailArg Specifies the number of repeated keypresses, if 
     *   available.
     * @param outputStringArg Specifies the <code>TextEvent</code>'s 
     *   <code>outputString</code> attribute
     * @param keyValArg Specifies the <code>TextEvent</code>'s 
     *   <code>keyVal</code>attribute
     * @param virtKeyValArg Specifies the <code>TextEvent</code>'s 
     *   <code>virtKeyVal</code>attribute
     * @param visibleOutputGeneratedArg Specifies the <code>TextEvent</code>
     *   's <code>visibleOutputGenerated</code>attribute
     * @param numPadArg Specifies the <code>TextEvent</code>'s 
     *   <code>numPad</code>attribute
     */
    public void initTextEvent(String typeArg, 
                              boolean canBubbleArg, 
                              boolean cancelableArg, 
                              AbstractView viewArg, 
                              short detailArg, 
                              String outputStringArg, 
                              int keyValArg, 
                              int virtKeyValArg, 
                              boolean visibleOutputGeneratedArg, 
                              boolean numPadArg);

    /**
     * The <code>initModifier</code> method is used to initialize the values 
     * of any modifiers associated with a <code>TextEvent</code> created 
     * through the <code>DocumentEvent</code> interface. This method may 
     * only be called before the <code>TextEvent</code> has been dispatched 
     * via the dispatchEvent method, though it may be called multiple times 
     * during that phase if necessary. If called multiple times with the 
     * same <code>modifier</code> property the final invocation takes 
     * precedence. Unless explicitly give a value of true, all modifiers 
     * have a value of false. This method has no effect if called after the 
     * event has been dispatched. 
     * <br>The list of keys below represents the allowable modifier paramaters 
     * for this method.DOM_VK_LEFT_ALTDOM_VK_RIGHT_ALTDOM_VK_LEFT_CONTROL
     * DOM_VK_RIGHT_CONTROLDOM_VK_LEFT_SHIFTDOM_VK_RIGHT_SHIFTDOM_VK_META
     * @param modifier The modifier which the user wishes to initialize
     * @param value The new value of the modifier.
     */
    public void initModifier(int modifier, 
                             boolean value);

}
