/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

/**
 * The <code>EventListenerList</code> interface provides the abstraction of an 
 * ordered collection of event listeners, without defining or constraining 
 * how this collection is implemented. <code>EventListenerList</code> 
 * objects in the DOM are live.
 * <p>The items in the <code>EventListenerList</code> are accessible via an 
 * integral index, starting from 0.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Events-20010823'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface EventListenerList {
    /**
     * Returns the <code>index</code>th item in the collection. If 
     * <code>index</code> is greater than or equal to the number of event 
     * listeners in the list, this returns <code>null</code>.
     * @param index Index into the collection.
     * @return The event listener at the <code>index</code>th position in the 
     *   <code>EventListenerList</code>, or <code>null</code> if that is not 
     *   a valid index.
     */
    public EventListener item(int index);

    /**
     * The number of event listeners in the list. The range of valid event 
     * listener indices is 0 to <code>length-1</code> inclusive.
     */
    public int getLength();

}
