/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

/**
 * The <code>DocumentEventGroup</code> interface provides a mechanism by which 
 * the user can create an <code>EventGroup</code> of a type supported by the 
 * implementation. It is expected that the <code>DocumentEvent</code> 
 * interface will be implemented on the same object which implements the 
 * <code>Document</code>interface in an implementation which supports the 
 * <code>EventGroup</code>extension.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Events-20010823'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface DocumentEventGroup {
    /**
     *  This method creates a new EventGroup for use in the addEventListener 
     * and removeEventListener methods of the EventTargetGroup interface.
     * @return  The newly created <code>EventGroup</code>.
     */
    public EventGroup createEventGroup();

}
