/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

import org.w3c.dom.EventListener;

/**
 * The EventTargetGroup interface is implemented by the same set of objects 
 * that implement the <code>EventTarget</code> interface, namely all 
 * <code>EventTarget</code>s in in implementation which supports the Event 
 * model and the EventGroup extension.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Events-20010410'>Document Object Model (DOM) Level 3 Events Specification</a>.
 */
public interface EventTargetGroup {
    /**
     * This method is equivalent to the <code>addEventListener</code> method 
     * of the <code>EventTarget</code> interface, with the exception of the 
     * added <code>eventGroup</code> parameter. The listener is registered 
     * with this <code>EventGroup</code> associated.
     * @param type 
     * @param listener 
     * @param useCapture 
     * @param eventGroup The <code>EventGroup</code> to associate with the 
     *   listener.
     */
    public void addEventListener(String type, 
                                 EventListener listener, 
                                 boolean useCapture, 
                                 EventGroup eventGroup);

    /**
     *  This method is equivalent to the <code>removeEventListener</code> 
     * method of the <code>EventTarget</code> interface, with the exception 
     * of the added <code>eventGroup</code> parameter. The listener 
     * registered with this <code>EventGroup</code> associated is removed.
     * @param type 
     * @param listener 
     * @param useCapture 
     * @param eventGroup The <code>EventGroup</code> to associate with the 
     *   listener.
     */
    public void removeEventListener(String type, 
                                    EventListener listener, 
                                    boolean useCapture, 
                                    EventGroup eventGroup);

}
