/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

/**
 * The EventGroup interface functions primarily as a placeholder for 
 * separating the event flows when there are multiple groups of listeners 
 * for a DOM tree.
 * <p><code>EventListener</code>s can be registered without an 
 * <code>EventGroup</code> using the existing <code>EventTarget</code> 
 * interface, or with an associated <code>EventGroup</code> using the new 
 * <code>EventTargetGroup</code> interface. When an event is dispatched, it 
 * is dispatched independently to each <code>EventGroup</code>. In 
 * particular, the <code>stopPropagation</code> method of the 
 * <code>Event</code> interface only stops propagation within an 
 * <code>EventListener</code>'s associated <code>EventGroup</code>. 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Events-20010410'>Document Object Model (DOM) Level 3 Events Specification</a>.
 */
public interface EventGroup {
    /**
     *  This method checks if the supplied <code>EventGroup</code> is the same 
     * as the <code>EventGroup</code> upon which the method is called.
     * @param eventGroup  The <code>EventGroup</code> with which to check 
     *   equality. 
     * @return Returns true if the <code>EventGroup</code>s are equal, else 
     *   returns false.
     */
    public boolean isSameEventGroup(EventGroup eventGroup);

}
