/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom;


/**
 * This interface extends the <code>Node</code> interface with several new 
 * methods. One allows to compare a node against another with regard to 
 * document order. Another methode allows to retrieve the content of a node 
 * and its descendants as a single DOMString. One allows to test whether two 
 * nodes are the same. Two methods provide for searching the namespace URI 
 * associated to a given prefix and to ensure the document is "namespace 
 * wellformed". Finally, it also provides a new attribute to get the base 
 * URI of a node, as defined in the XML Infoset.The term namespace wellformed
 *  needs to be defined.Define it as "being conformant to the Namespaces in 
 * XML spec" in the glossary (Telcon 4 Jul 2000).
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-Core-20010126'>Document Object Model (DOM) Level 3 Core Specification</a>.
 */
public interface Node3 {
    /**
     * Returns the absolute base URI of this node.How will this be affected by 
     * resolution of relative namespace URIs issue?Should this only be on 
     * Document, Element, ProcessingInstruction, Entity, and Notation nodes, 
     * according to the infoset? If not, what is it equal to on other nodes? 
     * Null? An empty string?Should this be read-only and computed or and 
     * actual read-write attribute?The former (F2F 19 Jun 2000).
     */
    public String getBaseURI();


    public static final int DOCUMENT_ORDER_PRECEDING= 1;
    public static final int DOCUMENT_ORDER_FOLLOWING= 2;
    public static final int DOCUMENT_ORDER_SAME= 3;
    public static final int DOCUMENT_ORDER_UNORDERED= 4;

    /**
     * Compares a node with this node with regard to document order.Should an 
     * exception be raised when comparing attributes? Entities and 
     * notations? An element against an attribute? If yes, which one? 
     * HIERARCHY_REQUEST_ERR? Should the enum value "unordered" be killed 
     * then?No, return unordered for attributes (F2F 19 Jun 2000).Should 
     * this method be moved to Node and take only one node in argument?Yes 
     * (F2F 19 Jun 2000).Should this method be optional?
     * @param other The node to compare against this node.
     * @return Returns how the given node compares with this node in document 
     *   order.
     * @exception DOMException
     *   WRONG_DOCUMENT_ERR: Raised if the given node does not belong to the 
     *   same document as this node.
     */
    public int compareDocumentOrder(Node other)
                                    throws DOMException;


    public static final int TREE_POSITION_PRECEDING= 1;
    public static final int TREE_POSITION_FOLLOWING= 2;
    public static final int TREE_POSITION_ANCESTOR= 3;
    public static final int TREE_POSITION_DESCENDANT= 4;
    public static final int TREE_POSITION_SAME= 5;
    public static final int TREE_POSITION_UNORDERED= 6;

    /**
     * Compares a node with this node with regard to their position in the 
     * tree.Should this method be optional?
     * @param other The node to compare against this node.
     * @return Returns how the given node is positioned relatively to this 
     *   node.
     * @exception DOMException
     *   WRONG_DOCUMENT_ERR: Raised if the given node does not belong to the 
     *   same document as this node.
     */
    public int compareTreePosition(Node other)
                                   throws DOMException;

    /**
     * This attribute returns the text content of this node and its 
     * descendants. When set, any possible children this node may have are 
     * removed and replaced by a single <code>Text</code> node containing 
     * the string this attribute is set to. On getting, no serialization is 
     * performed, the returned string does not contain any markup. 
     * Similarly, on setting, no parsing is performed either, the input 
     * string is taken as pure textual content.
     * <br>The string returned is made of the text content of this node 
     * depending on its type, as defined below: Node typeContent
     * ELEMENT_NODE, ENTITY_NODE, ENTITY_REFERENCE_NODE, DOCUMENT_NODE, 
     * DOCUMENT_FRAGMENT_NODEconcatenation of the <code>textContent</code> 
     * attribute value of every child node, excluding COMMENT_NODE and 
     * PROCESSING_INSTRUCTION_NODE nodesATTRIBUTE_NODE, TEXT_NODE, 
     * CDATA_SECTION_NODE, COMMENT_NODE, PROCESSING_INSTRUCTION_NODE
     * <code>nodeValue</code>DOCUMENT_TYPE_NODE, NOTATION_NODEempty string 
     * Should any whitespace normalization be performed?Should this be two 
     * methods instead?What about the name?Should this be optional? If yes, 
     * how do we signal it is not supported?
     */
    public String getTextContent();
    public void setTextContent(String textContent);

    /**
     * Returns whether this node is the same node as the given one.Do we 
     * really want to make this different from equals?Yes, change name from 
     * isIdentical to isSameNode. (Telcon 4 Jul 2000).Is this really needed 
     * if we provide a unique key?
     * @param other The node to test against.
     * @return Returns <code>true</code> if the nodes are the same, 
     *   <code>false</code> otherwise.
     */
    public boolean isSameNode(Node other);

    /**
     * Look up the prefix associated to the given namespace URI, starting from 
     * this node.Should this be optional?
     * @param namespaceURI The namespace URI to look for.
     * @return Returns the associated namespace prefix or <code>null</code> 
     *   if none is found.
     */
    public String lookupNamespacePrefix(String namespaceURI);

    /**
     * Look up the namespace URI associated to the given prefix, starting from 
     * this node.Name? May need to change depending on ending of the 
     * relative namespace URI reference nightmare.Should this be optional?
     * @param prefix The prefix to look for.
     * @return Returns the associated namespace URI or <code>null</code> if 
     *   none is found.
     */
    public String lookupNamespaceURI(String prefix);

    /**
     * This method walks down the tree, starting from this node, and adds 
     * namespace declarations where needed so that every namespace being 
     * used is properly declared. It also changes or assign prefixes when 
     * needed. This effectively makes this node subtree is "namespace 
     * wellformed".
     * <br>What the generated prefixes are and/or how prefixes are changed to 
     * achieve this is implementation dependent.Any other name?How specific 
     * should this be? Should we not even specify that this should be done 
     * by walking down the tree?What does this do on attribute nodes?Doesn't 
     * do anything (F2F 1 Aug 2000).How does it work with entity reference 
     * subtree which may be broken?This doesn't affect entity references 
     * which are not visited in this operation (F2F 1 Aug 2000).Should this 
     * be really be on Node?Yes, but this only works on Document, Element, 
     * and DocumentFragment. On other types it is a no-op. (F2F 1 Aug 2000).
     * What happens with read-only nodes?What/how errors should be reported? 
     * Are there any?Should this be optional?
     */
    public void normalizeNS();

    /**
     * This attribute returns a unique key identifying this node.What type 
     * should this really be?DOMKey, mapped to Object in Java and Number in 
     * ECMAScript (Telcon 13 Dec 2000).In what space is this key unique 
     * (Document, DOMImplementation)?What is the lifetime of the uniqueness 
     * of this key (Node, Document, ...)?
     */
    public Object getKey();

    /**
     * Tests whether two nodes are equal.
     * <br>This method tests for equality of nodes, not sameness (i.e., 
     * whether the two nodes are exactly the same object) which can be 
     * tested with <code>Node.isSameNode</code>. All objects that are the 
     * same will also be equal, though the reverse may not be true.Should 
     * this be optional?
     * @param arg The node to compare equality with.
     * @param deep If <code>true</code>, recursively compare the subtrees; if 
     *   <code>false</code>, compare only the nodes themselves (and its 
     *   attributes, if it is an <code>Element</code>).
     * @return If the nodes, and possibly subtrees are equal, 
     *   <code>true</code> otherwise <code>false</code>.
     */
    public boolean equalsNode(Node arg, 
                              boolean deep);

}
