/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.loadSave;

/**
 *  ParserErrorEvent is the event that is fired if there's an error in the XML 
 * document being parsed. 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface ParserErrorEvent {
    /**
     * An non-zero implementation dependent error code describing the error, 
     * or 0 if there is no error.
     */
    public int getErrorCode();

    /**
     * The byte position in the file where the error occurred.
     */
    public int getFilepos();

    /**
     * The line number where the error occurred.
     */
    public int getLine();

    /**
     * The number of the character on the line where the error occurred.
     */
    public int getLinepos();

    /**
     * An implementation dependent string describing the error, or an empty 
     * string if there was no error.
     */
    public String getReason();

    /**
     * The source of the line where the error occurred if available.
     */
    public String getSrcText();

    /**
     * The normalized URL of the document where the error occurred.
     */
    public String getUrl();

}
