/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.loadSave;

/**
 * This interface represents a single input source for an XML entity. 
 * <p> This interface allows an application to encapsulate information about 
 * an input source in a single object, which may include a public 
 * identifier, a system identifier, a byte stream (possibly with a specified 
 * encoding), and/or a character stream. 
 * <p> The exact definitions of a byte stream and a character stream are 
 * binding dependent. 
 * <p> There are two places that the application will deliver this input 
 * source to the parser: as the argument to the 
 * <code>parseDOMInputSource</code> method, or as the return value of the 
 * <code>DOMEntityResolver.resolveEntity</code> method. 
 * <p> The <code>DOMBuilder</code> will use the <code>DOMInputSource</code> 
 * object to determine how to read XML input. If there is a character stream 
 * available, the parser will read that stream directly; if not, the parser 
 * will use a byte stream, if available; if neither a character stream nor a 
 * byte stream is available, the parser will attempt to open a URI 
 * connection to the resource identified by the system identifier. 
 * <p> An <code>DOMInputSource</code> object belongs to the application: the 
 * parser shall never modify it in any way (it may modify a copy if 
 * necessary). 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DOMInputSource {
    /**
     * An attribute of a language-binding dependent type that represents a 
     * stream of bytes.
     * <br>The parser will ignore this if there is also a character stream 
     * specified, but it will use a byte stream in preference to opening a 
     * URI connection itself.
     * <br>If the application knows the character encoding of the byte stream, 
     * it should set the encoding property. Setting the encoding in this way 
     * will override any encoding specified in the XML declaration itself.
     */
    public java.io.InputStream getByteStream();
    /**
     * An attribute of a language-binding dependent type that represents a 
     * stream of bytes.
     * <br>The parser will ignore this if there is also a character stream 
     * specified, but it will use a byte stream in preference to opening a 
     * URI connection itself.
     * <br>If the application knows the character encoding of the byte stream, 
     * it should set the encoding property. Setting the encoding in this way 
     * will override any encoding specified in the XML declaration itself.
     */
    public void setByteStream(java.io.InputStream byteStream);

    /**
     * An attribute of a language-binding dependent type that represents a 
     * stream of 16 bit values (utf-16 encoded characters).
     * <br>If a character stream is specified, the parser will ignore any byte 
     * stream and will not attempt to open a URI connection to the system 
     * identifier.
     */
    public java.io.Reader getCharacterStream();
    /**
     * An attribute of a language-binding dependent type that represents a 
     * stream of 16 bit values (utf-16 encoded characters).
     * <br>If a character stream is specified, the parser will ignore any byte 
     * stream and will not attempt to open a URI connection to the system 
     * identifier.
     */
    public void setCharacterStream(java.io.Reader characterStream);

    /**
     * The character encoding, if known. The encoding must be a string 
     * acceptable for an XML encoding declaration (see section 4.3.3 of the 
     * XML 1.0 recommendation).
     * <br>This attribute has no effect when the application provides a 
     * character stream. For other sources of input, an encoding specified 
     * by means of this attribute will override any encoding specified in 
     * the XML or text declaration of the XML, or an encoding obtained from 
     * a higher level protocol, such as http.
     */
    public String getEncoding();
    /**
     * The character encoding, if known. The encoding must be a string 
     * acceptable for an XML encoding declaration (see section 4.3.3 of the 
     * XML 1.0 recommendation).
     * <br>This attribute has no effect when the application provides a 
     * character stream. For other sources of input, an encoding specified 
     * by means of this attribute will override any encoding specified in 
     * the XML or text declaration of the XML, or an encoding obtained from 
     * a higher level protocol, such as http.
     */
    public void setEncoding(String encoding);

    /**
     * The public identifier for this input source. The public identifier is 
     * always optional: if the application writer includes one, it will be 
     * provided as part of the location information.
     */
    public String getPublicId();
    /**
     * The public identifier for this input source. The public identifier is 
     * always optional: if the application writer includes one, it will be 
     * provided as part of the location information.
     */
    public void setPublicId(String publicId);

    /**
     * The system identifier for this input source. The system identifier is 
     * optional if there is a byte stream or a character stream, but it is 
     * still useful to provide one, since the application can use it to 
     * resolve relative URIs and can include it in error messages and 
     * warnings (the parser will attempt to open a connection to the URI 
     * only if there is no byte stream or character stream specified).
     * <br>If the application knows the character encoding of the object 
     * pointed to by the system identifier, it can register the encoding by 
     * setting the encoding attribute.
     * <br>If the system ID is a URL, it must be fully resolved.
     */
    public String getSystemId();
    /**
     * The system identifier for this input source. The system identifier is 
     * optional if there is a byte stream or a character stream, but it is 
     * still useful to provide one, since the application can use it to 
     * resolve relative URIs and can include it in error messages and 
     * warnings (the parser will attempt to open a connection to the URI 
     * only if there is no byte stream or character stream specified).
     * <br>If the application knows the character encoding of the object 
     * pointed to by the system identifier, it can register the encoding by 
     * setting the encoding attribute.
     * <br>If the system ID is a URL, it must be fully resolved.
     */
    public void setSystemId(String systemId);

}
