/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.loadSave;

/**
 *  <code>DOMImplementationLS</code> contains the factory methods for creating 
 * objects implementing the <code>DOMBuilder</code> (parser) and 
 * <code>DOMWriter</code> interfaces. 
 * <p>An object implementing DOMImplementationLS is obtained by casting from 
 * DOMImplementation to DOMImplementationLS, using the customary casting 
 * facilities from the programming language in use. Implementations 
 * supporting the Load and Save feature must implement the 
 * DOMImplementationLS interface on whatever object implements the 
 * DOMImplementation interface.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DOMImplementationLS {
    /**
     * Create a new <code>DOMBuilder</code>. The newly constructed parser may 
     * then be configured by means of its <code>setFeature()</code> method, 
     * and used to parse documents by means of its <code>parse()</code> 
     * method. 
     * @return The newly created parser object.
     */
    public DOMBuilder createDOMBuilder();

    /**
     * Create a new <code>DOMWriter</code> object. <code>DOMWriter</code>s are 
     * used to serialize a DOM tree back into source XML form. 
     * @return The newly created <code>DOMWriter</code> object.
     */
    public DOMWriter createDOMWriter();

}
