/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.Node;
import org.w3c.dom.DOMException;

/**
 * This interface extends the <code>Node</code> interface with additional 
 * methods for guided document editing.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface NodeCM extends Node {
    /**
     * Determines whether the <code>Node::InsertBefore</code> operation would 
     * make this document invalid with respect to the currently active CM. 
     * ISSUE: Describe "valid" when referring to partially completed 
     * documents.
     * @param newChild <code>Node</code> to be inserted.
     * @param refChild Reference <code>Node</code>.
     * @return A boolean that is true if the <code>Node::InsertBefore</code> 
     *   operation is allowed.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canInsertBefore(Node newChild, 
                                   Node refChild)
                                   throws DOMException;

    /**
     * Has the same args as <code>RemoveChild</code>.
     * @param oldChild <code>Node</code> to be removed.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canRemoveChild(Node oldChild)
                                  throws DOMException;

    /**
     * Has the same args as <code>ReplaceChild</code>.
     * @param newChild New <code>Node</code>.
     * @param oldChild <code>Node</code> to be replaced.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canReplaceChild(Node newChild, 
                                   Node oldChild)
                                   throws DOMException;

    /**
     * Has the same args as <code>AppendChild</code>.
     * @param newChild <code>Node</code> to be appended.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canAppendChild(Node newChild)
                                  throws DOMException;

    /**
     * Determines if the Node is valid relative to currently active CM.
     * @return True if the node is valid/well-formed in the current context 
     *   and check level defined by wfValidityCheckLevel, false if not.
     * @exception DOMException
     *   NO_CM_AVAILABLE: Exception is raised if the DocumentCM related to 
     *   this node does not have any activeCM and wfValidityCheckLevel is 
     *   set to STRICT_VALIDITY_CHECK.
     */
    public boolean isValid()
                           throws DOMException;

}
