/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.Node;
import org.w3c.dom.Element,NodeCM;
import org.w3c.dom.DOMException;

/**
 * This interface extends the <code>Element</code> interface with additional 
 * methods for guided document editing.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface ElementCM extends Element,NodeCM {
    /**
     * Determines element content type.
     * @return Constant for mixed, empty, any, etc.
     */
    public int contentType();

    /**
     * gets the CM editing object describing this element
     * @return CMElementDeclaration object
     * @exception DOMException
     *   If no DTD is present raises this exception
     */
    public CMElementDeclaration getElementDeclaration()
                                                      throws DOMException;

    /**
     * Determines if the value for specified attribute can be set.
     * @param attrname Name of attribute.
     * @param attrval Value to be assigned to the attribute.
     * @return true or false.
     */
    public boolean canSetAttribute(String attrname, 
                                   String attrval);

    /**
     * Determines if attribute node can be added.
     * @param node <code>Node</code> in which the attribute can possibly be 
     *   set.
     * @return Success or failure.
     */
    public boolean canSetAttributeNode(Node node);

    /**
     * Determines if the attribute node with the given namespace can be added.
     * @param node The <code>Attr</code> to be added to the attribute list.
     * @return Success or failure.
     */
    public boolean canSetAttributeNodeNS(Node node);

    /**
     * Determines if the attribute with given namespace and local name can be 
     * created if not already present in the attribute list of the element. 
     * If the attribute with same local name and namespaceURI is already 
     * present in the elements attribute list it sets the value of the 
     * attribute and its prefix to the new value. See DOM core 
     * <code>setAttributeNS</code>.
     * @param attrname Name of attribute.
     * @param attrval Value to be assigned to the attribute.
     * @param namespaceURI <code>namespaceURI</code> of namespace.
     * @param localName <code>localName</code> of namespace.
     * @return Success or failure.
     */
    public boolean canSetAttributeNS(String attrname, 
                                     String attrval, 
                                     String namespaceURI, 
                                     String localName);

    /**
     * Verifies if an attribute by the given name can be removed.
     * @param attrname Name of attribute.
     * @return true or false.
     */
    public boolean canRemoveAttribute(String attrname);

    /**
     * Verifies if an attribute by the given name and namespace can be removed.
     * @param attrname Qualified name of the attribute to be removed.
     * @param namespaceURI The namespace URI of the attribute to remove.
     * @return true or false.
     */
    public boolean canRemoveAttributeNS(String attrname, 
                                        String namespaceURI);

    /**
     * Determines if an attribute node can be removed.
     * @param node The <code>Attr</code> node to remove from the attribute 
     *   list.
     * @return true or false.
     */
    public boolean canRemoveAttributeNode(Node node);

}
