/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.DocumentType,NodeCM;

/**
 * This interface extends the <code>DocumentType</code> interface with 
 * additional methods for document editing.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DocumentTypeCM extends DocumentType,NodeCM {
    /**
     * Determines if this element is defined in the currently active CM.
     * @param elemTypeName Name of element.
     * @return Success or failure.
     */
    public boolean isElementDefined(String elemTypeName);

    /**
     * Determines if this element's namespace is defined in the currently 
     * active CM.
     * @param elemTypeName Name of element.
     * @param namespaceURI <code>namespaceURI</code> of namespace.
     * @param localName <code>localName</code> of namespace.
     * @return Success or failure.
     */
    public boolean isElementDefinedNS(String elemTypeName, 
                                      String namespaceURI, 
                                      String localName);

    /**
     * Determines if this attribute is defined for this element in the 
     * currently active CM.
     * @param elemTypeName Name of the element.
     * @param attrName Name of the attribute.
     * @return Success or failure.
     */
    public boolean isAttributeDefined(String elemTypeName, 
                                      String attrName);

    /**
     * Determines if this attribute's namespace is defined in the currently 
     * active CM.
     * @param elemTypeName Name of element.
     * @param attrName Name of attribute.
     * @param namespaceURI <code>namespaceURI</code> of namespace.
     * @param localName <code>localName</code> of namespace.
     * @return Success or failure.
     */
    public boolean isAttributeDefinedNS(String elemTypeName, 
                                        String attrName, 
                                        String namespaceURI, 
                                        String localName);

    /**
     * Determines if an entity is defined in the document. 
     * <br>ISSUE: Should methods be added to the DocumentTypeCM for the 
     * complete list of defined elements and for a particular element type, 
     * the complete list of defined attributes. These two methods might 
     * return a list of strings which is a type not yet described in the DOM 
     * spec. 
     * @param entName Name of entity.
     * @return Success or failure.
     */
    public boolean isEntityDefined(String entName);

}
