/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * This interface extends the <code>Document</code> interface with additional 
 * methods for both document and CM editing.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DocumentCM extends Document {
    /**
     * Check for well-formedness of the document.
     */
    public static final short WF_CHECK                  = 1;
    /**
     * Check for namespace well-formedness includes WF_CHECK.
     */
    public static final short NS_WF_CHECK               = 2;
    /**
     * Checks for whether the document is partially valid. It includes 
     * NS_WF_CHECK. 
     * <br> A document is said to be partially valid if it contains 
     * elments/attributes for which an element/attribute declaration has not 
     * been made in the active content model. However, if the element or the 
     * attribute has a declaration in the content model, it must be valid 
     * with respect to those declarations.  
     */
    public static final short PARTIAL_VALIDITY_CHECK    = 3;
    /**
     * Checks for strict validity of the document with respect to active CM 
     * which by defiition includes NS_WF_CHECK.
     */
    public static final short STRICT_VALIDITY_CHECK     = 4;
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. When set to true the implementation 
     * is free to raise the VALIDATION_ERR exception on DOM operations that 
     * would make the document invalid with respect to "partial validity". 
     * This attribute is false by default.Add VALIDATION_ERR code to the 
     * list of constants in DOMException.
     */
    public boolean getContinuousValidityChecking();
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. When set to true the implementation 
     * is free to raise the VALIDATION_ERR exception on DOM operations that 
     * would make the document invalid with respect to "partial validity". 
     * This attribute is false by default.Add VALIDATION_ERR code to the 
     * list of constants in DOMException.
     */
    public void setContinuousValidityChecking(boolean continuousValidityChecking);

    /**
     * This attribute defines the level at which the validity and 
     * welformedness testing is done by the <code>isValid</code> method.
     */
    public short getWfValidityCheckLevel();
    /**
     * This attribute defines the level at which the validity and 
     * welformedness testing is done by the <code>isValid</code> method.
     */
    public void setWfValidityCheckLevel(short wfValidityCheckLevel);

    /**
     * Determines number of <code>CMExternalModel</code>s associated with the 
     * document. Only one <code>CMModel</code> can be associated with the 
     * document, but it may point to a list of <code>CMExternalModel</code>s.
     * @return Non-negative number of external CM objects.
     */
    public int numCMs();

    /**
     * Find the sole <code>CMModel</code> of a document. Only one 
     * <code>CMModel</code> may be associated with the document.
     * @return <code>CMModel</code>.
     */
    public CMModel getInternalCM();

    /**
     * Obtains list of <code>CMNodes</code> of type
     * <code>CM_EXTERNALMODEL</code>s associated with the document.This list 
     * arises when <code>addCM()</code> is invoked.
     * @return A list of <code>CMExternalModel</code>s associated with a 
     *   document.
     */
    public CMNodeList getCMs();

    /**
     * Find the active <code>CMExternalModel</code> for a document.
     * @return <code>CMModel</code> with a pointer to the active 
     *   <code>CMExternalModel</code> of document.
     */
    public CMModel getActiveCM();

    /**
     * Associate a <code>CMModel</code> with a document. Can be invoked 
     * multiple times to result in a list of <code>CMExternalModel</code>s. 
     * Note that only one sole internal <code>CMModel</code> is associated 
     * with the document, however, and that only one of the possible list of 
     * <code>CMExternalModel</code>s is active at any one time.
     * @param cm CM to be associated with the document.
     */
    public void addCM(CMModel cm);

    /**
     * Removes a CM associated with a document; actually removes a 
     * <code>CMExternalModel</code>. Can be invoked multiple times to remove 
     * a number of these in the list of <code>CMExternalModel</code>s.
     * @param cm CM to be removed.
     */
    public void removeCM(CMModel cm);

    /**
     * Make the given <code>CMModel</code> active. Note that if a user wants 
     * to activate one CM to get default attribute values and then activate 
     * another to do validation, a user can do that; however, only one CM is 
     * active at a time. In case where an attribute is declared in an 
     * internal subset and corresponding <code>ownerElement</code> points to 
     * <code>CMElementDeclaration</code> defined in an external subset, 
     * changing active CM will cause the <code>ownerElement</code> to be 
     * re-computed. If the owner element is not defined in the newly active 
     * CM, the <code>ownerElement</code> will be an empty node list.
     * @param cm CM to be active for the document. The <code>CMModel</code> 
     *   points to a list of <code>CMExternalModel</code>s; with this call, 
     *   only the specified CM will be active.
     * @return True if the <code>CMModel</code> has already been associated 
     *   with the document using <code>addCM()</code>; false if not.
     */
    public boolean activateCM(CMModel cm);

}
