/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.Node;

/**
 * This interface provides document location information and is similar to a 
 * SAX locator object.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DOMLocator {
    /**
     * Return the column number.
     * @return The column number, or -1 if none is available. 
     */
    public int getColumnNumber();

    /**
     * Return the line number.
     * @return The line number, or -1 if none is available. 
     */
    public int getLineNumber();

    /**
     * Return the public identifier.
     * @return A string containing the public identifier, or null if none is 
     *   available.
     */
    public String getPublicID();

    /**
     * Return the system identifier.
     * @return A string containing the system identifier, or null if none is 
     *   available. 
     */
    public String getSystemID();

    /**
     * Return the Node.
     * @return The NODE, or null if none is available. 
     */
    public Node getNode();

}
