/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.DOMSystemException;

/**
 * Basic interface for DOM error handlers. If an application needs to 
 * implement customized error handling for DOM such as CM or Load/Save, it 
 * must implement this interface and then register an instance using the 
 * <code>setErrorHandler</code> method. All errors and warnings will then be 
 * reported through this interface. Application writers can override the 
 * methods in a subclass to take user-specified actions.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface DOMErrorHandler {
    /**
     * Receive notification of a warning per the W3C XML 1.0 recommendation. 
     * The default behavior if the user doesn't register a handler is to 
     * report conditions that are not errors or fatal errors, and then allow 
     * the calling application to continue even after invoking this method.
     * @param where Location of the warning, which could be either a source 
     *   position in the case of loading, or a node reference for later 
     *   validation. The public ID and system ID for the error location 
     *   could be some of the information. 
     * @param how How the warning occurred.
     * @param why Why the warning occurred.
     * @exception DOMSystemException
     *   A subclass of DOMException.
     */
    public void warning(DOMLocator where, 
                        String how, 
                        String why)
                        throws DOMSystemException;

    /**
     * Report a fatal, non-recoverable CM or Load/Save error per section 1.2 
     * of the W3C XML 1.0 recommendation. The default behavior if the user 
     * doesn't register a handler is to throw a DOMSystemException and stop 
     * all further processing.
     * @param where Location of the fatal error, which could be either a 
     *   source position in the case of loading, or a node reference for 
     *   later validation. The public ID and system ID for the error 
     *   location could be some of the information. 
     * @param how How the fatal error occurred.
     * @param why Why the fatal error occurred.
     * @exception DOMSystemException
     *   A subclass of DOMException.
     */
    public void fatalError(DOMLocator where, 
                           String how, 
                           String why)
                           throws DOMSystemException;

    /**
     * Receive notification of a recoverable error per section 1.2 of the W3C 
     * XML 1.0 recommendation. The default behavior if the user doesn't 
     * register a handler is to report conditions that are not fatal errors, 
     * and allow the calling application to continue processing.
     * @param where Location of the error, which could be either a source 
     *   position in the case of loading, or a node reference for later 
     *   validation. The public ID and system ID for the error location 
     *   could be some of the information. 
     * @param how How the error occurred.
     * @param why Why the error occurred.
     * @exception DOMSystemException
     *   A subclass of DOMException.
     */
    public void error(DOMLocator where, 
                      String how, 
                      String why)
                      throws DOMSystemException;

}
