/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.Text,NodeCM;
import org.w3c.dom.DOMException;

/**
 * This interface extends the <code>CharacterData</code> interface with 
 * additional methods for document editing.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CharacterDataCM extends Text,NodeCM {
    /**
     * Determines if content is only whitespace.
     * @return True if content only whitespace; false for non-whitespace if 
     *   it is a text node in element content.
     */
    public boolean isWhitespaceOnly();

    /**
     * Determines if data can be set.
     * @param offset Offset.
     * @param arg Argument to be set.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canSetData(int offset, 
                              String arg)
                              throws DOMException;

    /**
     * Determines if data can be appended.
     * @param arg Argument to be appended.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canAppendData(String arg)
                                 throws DOMException;

    /**
     * Determines if data can be replaced.
     * @param offset Offset.
     * @param count Replacement.
     * @param arg Argument to be set.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canReplaceData(int offset, 
                                  int count, 
                                  String arg)
                                  throws DOMException;

    /**
     * Determines if data can be inserted.
     * @param offset Offset.
     * @param arg Argument to be set.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canInsertData(int offset, 
                                 String arg)
                                 throws DOMException;

    /**
     * Determines if data can be deleted.
     * @param offset Offset.
     * @param arg Argument to be set.
     * @return Success or failure.
     * @exception DOMException
     *   DOMException.
     */
    public boolean canDeleteData(int offset, 
                                 String arg)
                                 throws DOMException;

}
