/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

import org.w3c.dom.decimal;

/**
 * The primitive types supported by optional DOM CM implelementations. A DOM 
 * application can use the hasFeature method of the DOMImplementation 
 * interface to determine whether this interface is supported or not. The 
 * feature string for all the interfaces listed in this section is 
 * "CMPTYPES" and the version is "3.0". 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMPrimitiveType extends CMDataType {
    /**
     * code representing the <code>boolean</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short BOOLEAN_DATATYPE          = 2;
    /**
     * code representing the <code>float</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short FLOAT_DATATYPE            = 3;
    /**
     * code representing the <code>double</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short DOUBLE_DATATYPE           = 4;
    /**
     * code representing a <code>decimal</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short DECIMAL_DATATYPE          = 5;
    /**
     * code representing a <code>hexbinary</code> data type as defined in  XML 
     * Schema Datatypes.
     */
    public static final short HEXBINARY_DATATYPE        = 6;
    /**
     * code representing a <code>base64binary</code> data type as defined in 
     * XML Schema Datatypes.
     */
    public static final short BASE64BINARY_DATATYPE     = 7;
    /**
     * code representing an <code>uri reference</code> data type as defined in 
     * XML Schema Datatypes.@@uriReference is no longer part of the XML 
     * Schema PR draft.
     */
    public static final short ANYURI_DATATYPE           = 8;
    /**
     * code representing an <code>XML qualified name</code> data type as 
     * defined in XML Schema Datatypes.
     */
    public static final short QNAME_DATATYPE            = 9;
    /**
     * code representing a <code>duration</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short DURATION_DATATYPE         = 10;
    /**
     * code representing a<code>datetime</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short DATETIME_DATATYPE         = 11;
    /**
     * code representing a<code>date</code> data type as defined in XML Schema 
     * Datatypes.
     */
    public static final short DATE_DATATYPE             = 12;
    /**
     * code representing a <code>time</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short TIME_DATATYPE             = 13;
    /**
     * code representing a <code>yearmonth</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short YEARMONTH_DATATYPE        = 14;
    /**
     * code representing a <code>year</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short YEAR_DATATYPE             = 15;
    /**
     * code representing a <code>monthday</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short MONTHDAY_DATATYPE         = 16;
    /**
     * code representing a <code>day</code> data type as defined in XML Schema 
     * Datatypes.
     */
    public static final short DAY_DATATYPE              = 17;
    /**
     * code representing a <code>month</code> data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short MONTH_DATATYPE            = 18;
    /**
     * code representing a<code>NOTATION</code>data type as defined in XML 
     * Schema Datatypes.
     */
    public static final short NOTATION_DATATYPE         = 19;
    /**
     * The low value for a primitive DECIMAL_DATATYPE in the value range. 
     */
    public decimal getLowValue();
    /**
     * The low value for a primitive DECIMAL_DATATYPE in the value range. 
     */
    public void setLowValue(decimal lowValue);

    /**
     * The high value for a primitive DECIMAL_DATATYPE in the value range.
     */
    public decimal getHighValue();
    /**
     * The high value for a primitive DECIMAL_DATATYPE in the value range.
     */
    public void setHighValue(decimal highValue);

}
