/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * This interface represents a notation declaration. 
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMNotationDeclaration extends CMNode {
    /**
     * The name of this notation declaration.
     */
    public String getNotationName();
    /**
     * The name of this notation declaration.
     */
    public void setNotationName(String notationName);

    /**
     *  the URI representing the system identifier for the notation 
     * declaration, if present, null otherwise.
     */
    public String getSystemId();
    /**
     *  the URI representing the system identifier for the notation 
     * declaration, if present, null otherwise.
     */
    public void setSystemId(String systemId);

    /**
     * The string representing the public identifier for this notation 
     * declaration.
     */
    public String getPublicId();
    /**
     * The string representing the public identifier for this notation 
     * declaration.
     */
    public void setPublicId(String publicId);

}
