/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * <code>CMNode</code>is analogous to a <code>Node</code> in the Core DOM, 
 * e.g., an element declaration. This can exist for both 
 * <code>CMExternalModel</code> and <code>CMModel</code>. It should be able 
 * to handle constructs such as comments and processing instructions.
 * <p>Opaque.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMNode {
    /**
     * The node is an <code>CMElementDeclaration</code>.
     */
    public static final short CM_ELEMENT_DECLARATION    = 1;
    /**
     * The node is an <code>CMAttributeDeclaration</code>.
     */
    public static final short CM_ATTRIBUTE_DECLARATION  = 2;
    /**
     * The node is a <code>CMNotationDeclaration</code>.
     */
    public static final short CM_NOTATION_DECLARATION   = 3;
    /**
     * The node is an <code>CMEntityDeclaration</code>.
     */
    public static final short CM_ENTITY_DECLARATION     = 4;
    /**
     * The node is a <code>CMChildren</code>.
     */
    public static final short CM_CHILDREN               = 5;
    /**
     * The node is a <code>CMModel</code>.
     */
    public static final short CM_MODEL                  = 6;
    /**
     * The node is a <code>CMExternalModel</code>.
     */
    public static final short CM_EXTERNALMODEL          = 7;
    /**
     * A code representing the underlying object as defined above.
     */
    public short getCmNodeType();

    /**
     * The <code>CMModel</code> object associated with this CMNode. For a node 
     * of type <code>CM_MODEL</code>, this is <code>null</code>. 
     */
    public CMModel getOwnerCMModel();
    /**
     * The <code>CMModel</code> object associated with this CMNode. For a node 
     * of type <code>CM_MODEL</code>, this is <code>null</code>. 
     */
    public void setOwnerCMModel(CMModel ownerCMModel);

    /**
     * The <code> qualified name</code> of this CMNode depending on the CMNode 
     * type.
     */
    public String getNodeName();
    /**
     * The <code> qualified name</code> of this CMNode depending on the CMNode 
     * type.
     */
    public void setNodeName(String nodeName);

    /**
     * The namespace prefix of this node, or null if it is unspecified.
     */
    public String getPrefix();
    /**
     * The namespace prefix of this node, or null if it is unspecified.
     */
    public void setPrefix(String prefix);

    /**
     * Returns the local part of the <code>qualified name</code> of this 
     * CMNode.
     */
    public String getLocalName();
    /**
     * Returns the local part of the <code>qualified name</code> of this 
     * CMNode.
     */
    public void setLocalName(String localName);

    /**
     * The namespace URI of this node, or null if it is unspecified.
     */
    public String getNamespaceURI();
    /**
     * The namespace URI of this node, or null if it is unspecified.
     */
    public void setNamespaceURI(String namespaceURI);

    /**
     * Creates a copy of <code>CMNode</code>.
     * @return Cloned <code>CMNode</code>.
     */
    public CMNode clone();

}
