/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * Models a general entity declaration in a content model. The content model 
 * does not handle any parameter entity. It is assumed that the parameter 
 * entiites are expanded by the implementation as the content model is built.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMEntityDeclaration extends CMNode {
    /**
     * constant defining an internal entity.
     */
    public static final short INTERNAL_ENTITY           = 1;
    /**
     * constant defining an external entity.
     */
    public static final short EXTERNAL_ENTITY           = 2;
    /**
     * One of the INTERNAL_ENTITY or EXTERNAL_ENTITY.
     */
    public short getEntityType();
    /**
     * One of the INTERNAL_ENTITY or EXTERNAL_ENTITY.
     */
    public void setEntityType(short entityType);

    /**
     * The name of the declared general entity.
     */
    public String getEntityName();
    /**
     * The name of the declared general entity.
     */
    public void setEntityName(String entityName);

    /**
     * The replacement text for the internal entity. The entity references 
     * within the replacement text is kept intact. For entity of type 
     * EXTERNAL_ENTITY this is <code>null</code>.
     */
    public String getEntityValue();
    /**
     * The replacement text for the internal entity. The entity references 
     * within the replacement text is kept intact. For entity of type 
     * EXTERNAL_ENTITY this is <code>null</code>.
     */
    public void setEntityValue(String entityValue);

    /**
     * The system identifier associated with the entity, if specified. If the 
     * system identifier was not specified, this is <code>null</code>.
     */
    public String getSystemId();
    /**
     * The system identifier associated with the entity, if specified. If the 
     * system identifier was not specified, this is <code>null</code>.
     */
    public void setSystemId(String systemId);

    /**
     * The public identifier associated with the entity, if specified. If the 
     * public identifier was not specified, this is <code>null</code>.
     */
    public String getPublicId();
    /**
     * The public identifier associated with the entity, if specified. If the 
     * public identifier was not specified, this is <code>null</code>.
     */
    public void setPublicId(String publicId);

    /**
     * For unparsed entities, the name of the notation declaration for the 
     * entity. For parsed entities, this is <code>null</code>. 
     */
    public String getNotationName();
    /**
     * For unparsed entities, the name of the notation declaration for the 
     * entity. For parsed entities, this is <code>null</code>. 
     */
    public void setNotationName(String notationName);

}
