/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * The element name along with the content specification in the context of a 
 * <code>CMNode</code>.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMElementDeclaration extends CMNode {
    /**
     * Datatype of the element.
     */
    public CMDataType getElementType();
    /**
     * Datatype of the element.
     */
    public void setElementType(CMDataType elementType);

    /**
     * Boolean defining whether the element type contains child elements and 
     * PCDATA or PCDATA only for mixed element types. True if the element is 
     * of type PCDATA only. Relevant only for mixed content type elements. 
     */
    public boolean getIsPCDataOnly();

    /**
     * tagName of the element being declared.
     */
    public String getTagName();
    /**
     * tagName of the element being declared.
     */
    public void setTagName(String tagName);

    /**
     * Gets content type, e.g., empty, any, mixed, elements, PCDATA, of an 
     * element.
     * @return Content type constant.
     */
    public int getContentType();

    /**
     * Gets content model of element.
     * @return Content model of element.
     */
    public CMChildren getCMChildren();

    /**
     * Returns a <code>CMNamedNodeMap</code> containing 
     * <code>CMAttributeDeclarations</code> for all the attributes that can 
     * appear on this type of element.
     * @return Attributes list for this <code>CMNode</code>.
     */
    public CMNamedNodeMap getCMAttributes();

    /**
     * Returns a <code>CMNamedNodeMap</code> containing 
     * <code>CMElementDeclarations</code> for all the <code>Element</code>s 
     * that can appear as children of this type of element. Note that which 
     * ones can actually appear, and in what order, is defined by the 
     * <code>CMChildren</code>.
     * @return Children list for this <code>CMNode</code>.
     */
    public CMNamedNodeMap getCMGrandChildren();

}
