/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * The content model of a declared element.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMChildren extends CMNode {
    /**
     * Signifies unbounded upper limit. The MAX_LONG value is the maximum 
     * value of an unsigned long integer for a given language binding.
     */
    public static final int UNBOUNDED                 = MAX_LONG;
    /**
     * No operators defined on the <code>subModels</code>. This is usually the 
     * case where the subModels contain a single element declaration.
     */
    public static final short NONE                      = 0;
    /**
     * This constant value signifies a sequence operator ",".
     */
    public static final short SEQUENCE                  = 1;
    /**
     * This constant value signifies a choice operator "|". 
     */
    public static final short CHOICE                    = 2;
    /**
     * One of CHOICE or SEQUENCE. The operator is applied to all the 
     * components(CMNodes) in the the <code>subModels</code>. For example, 
     * if the list operator is CHOICE and the components in subModels are a, 
     * b and c then the content model for the element being declared is 
     * (a|b|c)
     */
    public short getListOperator();
    /**
     * One of CHOICE or SEQUENCE. The operator is applied to all the 
     * components(CMNodes) in the the <code>subModels</code>. For example, 
     * if the list operator is CHOICE and the components in subModels are a, 
     * b and c then the content model for the element being declared is 
     * (a|b|c)
     */
    public void setListOperator(short listOperator);

    /**
     * min occurrence for this content particle. Valid values are from 0 to 
     * UNBOUNDED.
     */
    public int getMinOccurs();
    /**
     * min occurrence for this content particle. Valid values are from 0 to 
     * UNBOUNDED.
     */
    public void setMinOccurs(int minOccurs);

    /**
     * maximum occurrence for this content particle. Valid values are from 0 
     * to UNBOUNDED.
     */
    public int getMaxOccurs();
    /**
     * maximum occurrence for this content particle. Valid values are from 0 
     * to UNBOUNDED.
     */
    public void setMaxOccurs(int maxOccurs);

    /**
     * Additional <code>CMNode</code>s in which the element can be defined.
     */
    public CMNodeList getSubModels();
    /**
     * Additional <code>CMNode</code>s in which the element can be defined.
     */
    public void setSubModels(CMNodeList subModels);

    /**
     * Removes the CMNode at the indicated index position in the submodel.
     * @param nodeIndex Index of the node being removed.
     * @return The node removed is returned as a result of this method call. 
     *   The method returns <code>null</code> if the index is outside the 
     *   bounds of the <code>subModels</code> list.
     */
    public CMNode removeCMNode(int nodeIndex);

    /**
     * Inserts a new node at a position in the submodel referred to by the 
     * nodeIndex. Node already exisiting in the list is moved as needed.
     * @param nodeIndex The position of where the newNode is inserted.
     * @param newNode The new node to be inserted.
     * @return The index value at which it is inserted. If the nodeIndex is 
     *   outside the bound of the <code>subModels</code> list, the item is 
     *   inserted at the back of the list. 
     */
    public int insertCMNode(int nodeIndex, 
                            CMNode newNode);

    /**
     * Appends a new node to the end of the list representing the
     * <code>subModels</code>.
     * @param newNode The new node to be appended.
     * @return the length of the <code>subModels</code>.
     */
    public int appendCMNode(CMNode newNode);

}
