/*
 * Copyright (c) 2001 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.contentModel;

/**
 * An attribute declaration in the context of a <code>CMNode</code>.
 * <p>See also the <a href='http://www.w3.org/TR/2001/WD-DOM-Level-3-CMLS-20010419'>Document Object Model (DOM) Level 3 Content Models and Load
and Save Specification</a>.
 */
public interface CMAttributeDeclaration extends CMNode {
    /**
     * Describes that the attribute does not have any value constraint.
     */
    public static final short NO_VALUE_CONSTRAINT       = 0;
    /**
     * Indicates that the there is a default value constraint.
     */
    public static final short DEFAULT_VALUE_CONSTRAINT  = 1;
    /**
     * Indicates that there is a fixed value constraint for this attribute.
     */
    public static final short FIXED_VALUE_CONSTRAINT    = 2;
    /**
     * Name of the attribute.
     */
    public String getAttrName();
    /**
     * Name of the attribute.
     */
    public void setAttrName(String attrName);

    /**
     * Datatype of the attribute.
     */
    public CMDataType getAttrType();
    /**
     * Datatype of the attribute.
     */
    public void setAttrType(CMDataType attrType);

    /**
     * Default value.
     */
    public String getAttributeValue();
    /**
     * Default value.
     */
    public void setAttributeValue(String attributeValue);

    /**
     * Enumeration of attribute.
     */
    public String getEnumAttr();
    /**
     * Enumeration of attribute.
     */
    public void setEnumAttr(String enumAttr);

    /**
     * Owner element CMNode of attribute.
     */
    public CMNodeList getOwnerElement();
    /**
     * Owner element CMNode of attribute.
     */
    public void setOwnerElement(CMNodeList ownerElement);

    /**
     * Constraint type if any for this attribute.
     */
    public short getConstraintType();
    /**
     * Constraint type if any for this attribute.
     */
    public void setConstraintType(short constraintType);

}
