<?xml version="1.0" standalone="no"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- Add DOCTYPE -->
  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 20010719//EN" 
      "http://www.w3.org/TR/2001/PR-SVG-20010719/DTD/svg10.dtd"&gt;
</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <!-- Add styling to all 'rect' elements -->
  <xsl:template match="rect">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="fill">red</xsl:attribute>
      <xsl:attribute name="stroke">blue</xsl:attribute>
      <xsl:attribute name="stroke-width">3</xsl:attribute>
    </xsl:copy>
  </xsl:template>

  <!-- default is to copy input element -->
  <xsl:template match="*|@*|text()">
    <xsl:copy>
      <xsl:apply-templates select="*|@*|text()"/>
    </xsl:copy>
  </xsl:template>
</xsl:stylesheet>
