<!-- ....................................................................... -->
<!-- VOICEXML 2.0 Document Model Module  ................................... -->
<!-- file: VOICEXML20-model-1.mod

     This is VOICEXML 2.0, a reformulation of VOICEXML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: VOICEXML20-model-1.mod, v 0.1 2001/10/19 3:37:01 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ENTITIES VOICEXML 2.0 Document Model 1.0//EN"
       SYSTEM "http://www.w3.org/TR/voicexml/DTD/VOICEXML20-model-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- VOICEXML 2.0 Document Model

     This module describes the groupings of elements that make the content
     model for VOICEXML elements.

     VOICEXML has two basic content model:

         %Exec.mix;    Executable content elements
         %Vxml.mix;    Top-level content elements

     Any parameter entities declared in this module may be used
     to create element content models, but the above is considered
     'global' (insofar as that term applies here).

     The reserved word '#PCDATA' (indicating a text string) is now
     included explicitly with each element declaration that is
     declared as mixed content, as XML requires that this token
     occur first in a content model specification.
-->
<!-- Extending the Model

     While in some cases this module may need to be rewritten to
     accommodate changes to the document model, minor extensions
     may be accomplished by redeclaring the following *.extra;
     parameter entity to contain extension element types:

         %Misc.extra;    whose parent may be any element.
                         inline element.

     If used, these parameter entities must be an OR-separated
     list beginning with an OR separator ("|"), eg., "| a | b | c"
-->

<!-- .................  Miscellaneous Elements  .................. -->

<!ENTITY % Misc.extra "" >

<!-- These elements can essentially be used anywhere in
     the document body.
-->
<!ENTITY % Misc.class "%Misc.extra;" >

<!-- ................  Executable Content Elements ............ -->
<!ENTITY % Audio.class "| %audio.qname;" >
<!ENTITY % Enumerate.class "| %enumerate.qname;" >
<!ENTITY % Assign.class "| %assign.qname;" >
<!ENTITY % Clear.class "| %clear.qname;" >
<!ENTITY % Disconnect.class "| %disconnect.qname;" >
<!ENTITY % Exit.class "| %exit.qname;" >
<!ENTITY % Goto.class "| %goto.qname;" >
<!ENTITY % If.class "| %if.qname;" >
<!ENTITY % Log.class "| %log.qname;" >
<!ENTITY % Reprompt.class "| %reprompt.qname;" >
<!ENTITY % Return.class "| %return.qname;" >
<!ENTITY % Script.class "| %script.qname;" >
<!ENTITY % Submit.class "| %submit.qname;" >
<!ENTITY % Throw.class "| %throw.qname;" >
<!ENTITY % Value.class "| %value.qname;" >
<!ENTITY % Var.class "| %var.qname;" >

<!ENTITY % Exec.extra "" >
<!ENTITY % Audio.mix 
	"#PCDATA
	 %Audio.class;
	 %Enumerate.class;
	 %Value.class;" >

<!ENTITY % Exec.class 
	"%Audio.mix;
	 %Assign.class;
	 %Clear.class;
	 %Disconnect.class;
	 %Exit.class;
	 %Goto.class;
	 %If.class;
	 %Log.class;
	 %Reprompt.class;
	 %Return.class;
	 %Script.class;
	 %Submit.class;
	 %Throw.class;
	 %Var.class;
	 %Exec.extra;"
>

<!ENTITY % Exec.mix 
	"%Exec.class;
	 %Misc.class;"
>

<!-- ................  Event Handler Elements ............... -->
<!ENTITY % EventHandler.class 
	"%catch.qname; | %help.qname; | %noinput.qname; | %nomatch.qname; | %error.qname;"
>

<!-- ................  SSML Elements ........................ -->
<!ENTITY % SentenceElements.class
	"%break.qname; | %emphasis.qname; | %phoneme.qname; |
	 %mark.qname; | %prosody.qname; | %say-as.qname; | %voice.qname;"
>
<!ENTITY % Paragraph.class "%paragraph.qname; | %p.qname;" >
<!ENTITY % Sentence.class "%sentence.qname; | %s.qname;" >
<!ENTITY % Structure.class "%Paragraph.class; | %Sentence.class;" >

<!-- .................  TTS.mix; system output elements ..... -->
<!ENTITY % TTS.mix "%SentenceElements.class | %Structure.class;" >

<!-- ................  Dialog Content Elements .............. -->
<!ENTITY % Grammar.class "| %grammar.qname;" >
<!ENTITY % Filled.class "| %filled.qname;" >
<!ENTITY % Initial.class "| %initial.qname;" >
<!ENTITY % Object.class "| %object.qname;" >
<!ENTITY % Record.class "| %record.qname;" >
<!ENTITY % Subdialog.class "| %subdialog.qname;" >
<!ENTITY % Transfer.class "| %transfer.qname;" >
<!ENTITY % Variable.class "| %block.qname; | %field.qname; | %var.qname;" >
<!ENTITY % Param.class "| %param.qname;" >
<!ENTITY % Prompt.class "| %prompt.qname;" >

<!-- ................  VXML-child Elements  .................. -->
<!ENTITY % Form.class "| %form.qname;" >
<!ENTITY % Link.class "%| link.qname;" >
<!ENTITY % Menu.class "| %menu.qname;" >
<!ENTITY % Meta.class "| %meta.qname;" >
<!ENTITY % Property.class "| %property.qname;" >
<!ENTITY % Script.class "| %script.qname;" >
<!ENTITY % Var.class "| %var.qname;" >

<!ENTITY % Vxml.extra "" >

<!-- %Vxml.class; includes vxml-child elements -->
<!ENTITY % Vxml.class
     "%EventHandler.class;
      %Form.class;
      %Link.class;
      %Menu.class;
	%Meta.class;
	%Property.class;
	%Script.class;
	%Var.class;
      %Vxml.extra;"
>

<!-- %Vxml.mix; includes all elements plus %Misc.class; -->
<!ENTITY % Vxml.mix
     "%Vxml.class;
      %Misc.class;"
>

<!-- end of VOICEXML20-model-1.mod -->