<!-- ...................................................................... -->
<!-- Voice XML Miscellaneous Module  ...................................... -->
<!-- file: voicexml-misc-1.mod

     This is VoiceXML 2.0, a reformulation of Voice XML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: voicexml-misc-1.mod,v 0.1 2001/10/24 00:00:00 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ELEMENTS VOICEXML Miscellaneous 1.0//EN"
       SYSTEM "http://www.w3.org/TR/voicexml-modularization/DTD/voicexml-misc-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Miscellaneous elements

        exit, goto, link, script, submit

     This module declares miscellaneous element types and their attributes.
--> 

<!ENTITY % VOICEXML.exit.qname "exit" >
<!ENTITY % VOICEXML.goto.qname "goto" >
<!ENTITY % VOICEXML.link.qname "link" >
<!ENTITY % VOICEXML.script.qname "script" >
<!ENTITY % VOICEXML.submit.qname "submit" >

<!-- exit:  Definition List ............................ -->

<!ENTITY % exit.element "INCLUDE" >
<![%exit.element;[
<!ENTITY % exit.content "EMPTY" >
<!ELEMENT %VOICEXML.exit.qname; %exit.content; >
<!-- end of exit.element -->]]>

<!ENTITY % exit.attlist "INCLUDE" >
<![%exit.attlist;[
<!ATTLIST %VOICEXML.exit.qname;
	expr %Script.datatype; #IMPLIED 
	namelist %FieldNames.datatype; #IMPLIED >
<!-- end of exit.attlist -->]]>

<!-- goto:  Definition List ............................ -->

<!ENTITY % goto.element "INCLUDE" >
<![%goto.element;[
<!ENTITY % goto.content "EMPTY" >
<!ELEMENT %VOICEXML.goto.qname; %goto.content; >
<!-- end of goto.element -->]]>

<!ENTITY % goto.attlist "INCLUDE" >
<![%goto.attlist;[
<!ATTLIST %VOICEXML.goto.qname;
	%VOICEXML.Cache.attrib;
	%VOICEXML.Next.attrib;
	fetchaudio %URI.datatype; #IMPLIED
	expritem   %Script.datatype; #IMPLIED
	nextitem   %FieldName.datatype; #IMPLIED >
<!-- end of goto.attlist -->]]>

<!-- link:  Definition List ............................ -->

<!ENTITY % link.element "INCLUDE" >
<![%link.element;[
<!ENTITY % link.content "(%Grammar.class;)*" >
<!ELEMENT %VOICEXML.link.qname; %link.content; >
<!-- end of link.element -->]]>

<!ENTITY % link.attlist "INCLUDE" >
<![%link.attlist;[
<!ATTLIST %VOICEXML.link.qname;
	%VOICEXML.Cache.attrib;
	%VOICEXML.Next.attrib;
	fetchaudio 	%URI.datatype;  #IMPLIED
	dtmf		CDATA		    #IMPLIED
	event		%EventName.datatype; #IMPLIED >
<!-- end of link.attlist -->]]>

<!-- script:  Definition List ............................ -->

<!ENTITY % script.element "INCLUDE" >
<![%script.element;[
<!ENTITY % script.content "(#PCDATA)" >
<!ELEMENT %VOICEXML.script.qname; %script.content; >
<!-- end of script.element -->]]>

<!ENTITY % script.attlist "INCLUDE" >
<![%script.attlist;[
<!ATTLIST %VOICEXML.script.qname;
	src %URI.datatype; #IMPLIED
	charset CDATA #IMPLIED 
	%VOICEXML.Cache.attrib; >
<!-- end of script.attlist -->]]>

<!-- submit:  Definition List ............................ -->

<!ENTITY % submit.element "INCLUDE" >
<![%submit.element;[
<!ENTITY % submit.content "EMPTY" >
<!ELEMENT %VOICEXML.submit.qname; %submit.content; >
<!-- end of submit.element -->]]>

<!ENTITY % submit.attlist "INCLUDE" >
<![%submit.attlist;[
<!ATTLIST %VOICEXML.submit.qname;
	%VOICEXML.Cache.attrib;
	%VOICEXML.Next.attrib;
	fetchaudio %URI.datatype; #IMPLIED
	%VOICEXML.Submit.attrib; >
<!-- end of submit.attlist -->]]>

<!-- end of voicexml-misc-1.mod -->
