<!-- ...................................................................... -->
<!-- XHTML 1.1 Simplified Forms Module  ................................... -->
<!-- file: xhtml11-formb-1.mod

     This is a subset of XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-2000 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: xhtml11-formb-1.mod,v 1.3 2000/01/03 22:11:08 ahby Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Basic Forms 1.0//EN"  
     SYSTEM "xhtml11-formb-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Basic Forms

     This forms module is based on the HTML 3.2 forms model, with
     the WAI-requested addition of the label element. While this 
     module essentially mimics the content model and attributes of 
     HTML 3.2 forms, the element types declared herein also include
     all HTML 4.0 common attributes.

        form, label, input, select, option, textarea

     When Basic Forms are used in lieu of the default XHTML 1.1
     Forms module, the parameter entity %Inline.extra; must
     be redeclared in the model module to include:

        "| input | select | textarea | label"
-->

<!-- %Block-noform.mix; includes all non-form block elements,
     plus %Misc.class;
-->
<!ENTITY % Block-noform.mix
     "%Heading.class;
      | %List.class;
      | %Blkstruct.class;
      %Blkphras.class;
      %Blkpres.class;
      | table 
      %Misc.class;"
>

<!-- form: Form Element ................................ -->

<!ENTITY % Form.element  "INCLUDE" >
<![%Form.element;[
<!ENTITY % Form.content
     "( %Block-noform.mix; )+"
>
<!ELEMENT form  %Form.content; >
<!-- end of Form.element -->]]>

<!ENTITY % Form.attlist  "INCLUDE" >
<![%Form.attlist;[
<!ATTLIST form
      %Common.attrib;
      action       %URI.datatype;           #REQUIRED
      method       ( get | post )           'get'
      enctype      %ContentType.datatype;   'application/x-www-form-urlencoded'
>
<!-- end of Form.attlist -->]]>

<!-- label: Form Field Label Text ...................... -->

<!ENTITY % Label.element  "INCLUDE" >
<![%Label.element;[
<!-- Each label must not contain more than ONE field
-->
<!ENTITY % Label.content
     "( #PCDATA 
      | input | select | textarea | button
      | %Inlstruct.class;
      %Inlphras.class;
      %I18n.class;
      %Inlpres.class;
      %Inlspecial.class;
      %Misc.class; )*"
>
<!ELEMENT label  %Label.content; >
<!-- end of Label.element -->]]>

<!ENTITY % Label.attlist  "INCLUDE" >
<![%Label.attlist;[
<!ATTLIST label
      %Common.attrib;
      for          IDREF                    #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Label.attlist -->]]>

<!-- input: Form Control ............................... -->

<!ENTITY % Input.element  "INCLUDE" >
<![%Input.element;[
<!ENTITY % Input.content  "EMPTY" >
<!ELEMENT input  %Input.content; >
<!-- end of Input.element -->]]>

<!ENTITY % Input.attlist  "INCLUDE" >
<![%Input.attlist;[
<!ENTITY % InputType.class
     "( text | password | checkbox | radio | submit 
      | reset | file | hidden | image )"
>
<!-- attribute name required for all but submit & reset
-->
<!ATTLIST input
      %Common.attrib;
      type         %InputType.class;        'text'
      name         CDATA                    #IMPLIED
      value        CDATA                    #IMPLIED
      checked      ( checked )              #IMPLIED
      size         CDATA                    #IMPLIED
      maxlength    %Number.datatype;        #IMPLIED
      src          %URI.datatype;           #IMPLIED
>
<!-- end of Input.attlist -->]]>

<!-- select: Option Selector ........................... -->

<!ENTITY % Select.element  "INCLUDE" >
<![%Select.element;[
<!ENTITY % Select.content  "( option )+" >
<!ELEMENT select  %Select.content; >
<!-- end of Select.element -->]]>

<!ENTITY % Select.attlist  "INCLUDE" >
<![%Select.attlist;[
<!ATTLIST select
      %Common.attrib;
      name         CDATA                    #IMPLIED
      size         %Number.datatype;        #IMPLIED
      multiple     ( multiple )             #IMPLIED
>
<!-- end of Select.attlist -->]]>

<!-- option: Selectable Choice ......................... -->

<!ENTITY % Option.element  "INCLUDE" >
<![%Option.element;[
<!ENTITY % Option.content  "( #PCDATA )" >
<!ELEMENT option  %Option.content; >
<!-- end of Option.element -->]]>

<!ENTITY % Option.attlist  "INCLUDE" >
<![%Option.attlist;[
<!ATTLIST option
      %Common.attrib;
      selected     ( selected )             #IMPLIED
      value        CDATA                    #IMPLIED
>
<!-- end of Option.attlist -->]]>

<!-- textarea: Multi-Line Text Field ................... -->

<!ENTITY % Textarea.element  "INCLUDE" >
<![%Textarea.element;[
<!ENTITY % Textarea.content  "( #PCDATA )" >
<!ELEMENT textarea  %Textarea.content; >
<!-- end of Textarea.element -->]]>

<!ENTITY % Textarea.attlist  "INCLUDE" >
<![%Textarea.attlist;[
<!ATTLIST textarea
      %Common.attrib;
      name         CDATA                    #IMPLIED
      rows         %Number.datatype;        #REQUIRED
      cols         %Number.datatype;        #REQUIRED
>
<!-- end of Textarea.attlist -->]]>

<!-- end of xhtml11-formb-1.mod -->
