<!-- ...................................................................... -->
<!-- XHTML 1.1 Client-side Image Map Module  .............................. -->
<!-- file: xhtml11-csismap-1.mod

     This is XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-2000 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: xhtml11-csismap-1.mod,v 1.3 2000/01/03 22:11:08 ahby Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Client-side Image Maps 1.0//EN"
     SYSTEM "xhtml11-csismap-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Client-side Image Maps

        area, map

     This module declares elements and attributes to support client-side
     image maps. This requires that the Image Module (or a module
     declaring the img element type) be included in the DTD.

     These can be placed in the same document or grouped in a
     separate document, although the latter isn't widely supported
-->

<!ENTITY % Area.element  "INCLUDE" >
<![%Area.element;[
<!ENTITY % Area.content  "EMPTY" >
<!ELEMENT area  %Area.content; >
<!-- end of Area.element -->]]>

<!ENTITY % Shape.datatype "( rect | circle | poly | default )">
<!ENTITY % Coords.datatype "CDATA" >

<!ENTITY % Area.attlist  "INCLUDE" >
<![%Area.attlist;[
<!ATTLIST area
      %Common.attrib;
      href         %URI.datatype;           #IMPLIED
      shape        %Shape.datatype;         'rect'
      coords       %Coords.datatype;        #IMPLIED
      nohref       ( nohref )               #IMPLIED
      alt          %Text.datatype;          #REQUIRED
      tabindex     %Number.datatype;        #IMPLIED
      accesskey    %Character.datatype;     #IMPLIED
>
<!-- end of Area.attlist -->]]>

<!-- modify anchor attribute definition list
     to allow for client-side image maps
-->
<!ATTLIST a
      shape        %Shape.datatype;         'rect'
      coords       %Coords.datatype;        #IMPLIED
>

<!-- modify img attribute definition list
     to allow for client-side image maps
-->
<!ATTLIST img
      usemap       IDREF                    #IMPLIED
>
<!-- 'usemap' points to the 'id' attribute of a MAP element,
     which must be in the same document; support for external
     document maps was not widely supported in HTML and is
     eliminated in XHTML.

     It is considered an error for the element pointed to by
     a usemap IDREF to occur in anything but a map element.
-->

<!ENTITY % Map.element  "INCLUDE" >
<![%Map.element;[
<!ENTITY % Map.content
     "(( %Block.mix; ) | area )+"
>
<!ELEMENT map  %Map.content; >
<!-- end of Map.element -->]]>

<!ENTITY % Map.attlist  "INCLUDE" >
<![%Map.attlist;[
<!ATTLIST map
      id           ID                       #REQUIRED
      %Class.attrib;
      %Title.attrib;
      %Core.extra.attrib;
      %I18n.attrib;
      %Events.attrib;
>
<!-- end of Map.attlist -->]]>

<!-- end of xhtml11-csismap-1.mod -->
