<!-- ...................................................................... -->
<!-- XHTML 1.1 Block Phrasal Module  ...................................... -->
<!-- file: xhtml11-blkphras-1.mod

     This is XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-2000 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: xhtml11-blkphras-1.mod,v 1.3 2000/01/03 22:11:08 ahby Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Block Phrasal 1.0//EN"
     SYSTEM "xhtml11-blkphras-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Block Phrasal

        address, blockquote, pre, h1, h2, h3, h4, h5, h6

     This module declares the elements and their attributes used to
     support block-level phrasal markup.
-->

<!ENTITY % Address.element  "INCLUDE" >
<![%Address.element;[
<!ENTITY % Address.content
     "( #PCDATA | %Inline.mix; )*" >
<!ELEMENT address  %Address.content; >
<!-- end of Address.element -->]]>

<!ENTITY % Address.attlist  "INCLUDE" >
<![%Address.attlist;[
<!ATTLIST address
      %Common.attrib;
>
<!-- end of Address.attlist -->]]>

<!ENTITY % Blockquote.element  "INCLUDE" >
<![%Blockquote.element;[
<!ENTITY % Blockquote.content
     "( %Block.mix; )+"
>
<!ELEMENT blockquote  %Blockquote.content; >
<!-- end of Blockquote.element -->]]>

<!ENTITY % Blockquote.attlist  "INCLUDE" >
<![%Blockquote.attlist;[
<!ATTLIST blockquote
      %Common.attrib;
      cite         %URI.datatype;           #IMPLIED
>
<!-- end of Blockquote.attlist -->]]>

<!ENTITY % Pre.element  "INCLUDE" >
<![%Pre.element;[
<!ENTITY % Pre.content
     "( #PCDATA 
      | %Inlstruct.class;
      %Inlphras.class;
      | tt | i | b
      %I18n.class;
      %Anchor.class;
      | script | map
      %Inline.extra; )*"
>
<!ELEMENT pre  %Pre.content; >
<!-- end of Pre.element -->]]>

<!ENTITY % Pre.attlist  "INCLUDE" >
<![%Pre.attlist;[
<!ATTLIST pre
      %Common.attrib;
      xml:space    ( preserve )             #FIXED 'preserve'
>
<!-- end of Pre.attlist -->]]>

<!-- ...................  Heading Elements  ................... -->

<!ENTITY % Heading.content  "( #PCDATA | %Inline.mix; )*" >

<!ENTITY % H1.element  "INCLUDE" >
<![%H1.element;[
<!ELEMENT h1  %Heading.content; >
<!-- end of H1.element -->]]>

<!ENTITY % H1.attlist  "INCLUDE" >
<![%H1.attlist;[
<!ATTLIST h1
      %Common.attrib;
>
<!-- end of H1.attlist -->]]>

<!ENTITY % H2.element  "INCLUDE" >
<![%H2.element;[
<!ELEMENT h2  %Heading.content; >
<!-- end of H2.element -->]]>

<!ENTITY % H2.attlist  "INCLUDE" >
<![%H2.attlist;[
<!ATTLIST h2
      %Common.attrib;
>
<!-- end of H2.attlist -->]]>

<!ENTITY % H3.element  "INCLUDE" >
<![%H3.element;[
<!ELEMENT h3  %Heading.content; >
<!-- end of H3.element -->]]>

<!ENTITY % H3.attlist  "INCLUDE" >
<![%H3.attlist;[
<!ATTLIST h3
      %Common.attrib;
>
<!-- end of H3.attlist -->]]>

<!ENTITY % H4.element  "INCLUDE" >
<![%H4.element;[
<!ELEMENT h4  %Heading.content; >
<!-- end of H4.element -->]]>

<!ENTITY % H4.attlist  "INCLUDE" >
<![%H4.attlist;[
<!ATTLIST h4
      %Common.attrib;
>
<!-- end of H4.attlist -->]]>

<!ENTITY % H5.element  "INCLUDE" >
<![%H5.element;[
<!ELEMENT h5  %Heading.content; >
<!-- end of H5.element -->]]>

<!ENTITY % H5.attlist  "INCLUDE" >
<![%H5.attlist;[
<!ATTLIST h5
      %Common.attrib;
>
<!-- end of H5.attlist -->]]>

<!ENTITY % H6.element  "INCLUDE" >
<![%H6.element;[
<!ELEMENT h6  %Heading.content; >
<!-- end of H6.element -->]]>

<!ENTITY % H6.attlist  "INCLUDE" >
<![%H6.attlist;[
<!ATTLIST h6
      %Common.attrib;
>
<!-- end of H6.attlist -->]]>

<!-- end of xhtml11-blkphras-1.mod -->
