/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.views;

/**
 * Visual font resources contain match criteria and result attributes for 
 * getting information about fonts available to a view.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Views-20001115'>Document Object Model (DOM) Level 3 Views and Formatting
Specification</a>.
 */
public interface VisualFont extends VisualResource {
    /**
     * May be set to cause fonts with the corresponding name to be matched.
     */
    public String getMatchFontName();
    public void setMatchFontName(String matchFontName);

    /**
     * Returns true result if the desired font was located, or false if it was 
     * not. If this value is set to false, no other results are set. If this 
     * value is set to true, all other results are set.
     */
    public boolean getExists();

    /**
     * When a font is matched, the name of the font is returned here.
     */
    public String getFontName();

    /**
     * Fetches the results of the next matching <code>VisualFont</code>, if 
     * any.
     * @return 
     */
    public boolean getNext();

}
