/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.views;

/**
 * The <code>Item</code> represents information to be fetched by a 
 * <code>Segment</code>.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Views-20001115'>Document Object Model (DOM) Level 3 Views and Formatting
Specification</a>.
 * @since DOM Level 3
 */
public interface Item {
    /**
     * The <code>exists</code> boolean of a <code>Segment</code>, initially 
     * set to false during creation, is set after an attempt to fetch the 
     * values of a <code>Item</code> to indicate whether or not the required 
     * data was present. A true value indicates that it was.
     */
    public boolean getExists();

    /**
     * The name of a property of the matched <code>Segment</code> to be 
     * fetched, which is specified during construction.
     */
    public String getName();

}
