/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

import org.w3c.dom.views.AbstractView;
import org.w3c.dom.UIEvent;

/**
 * The <code>KeyEvent</code> interface provides specific contextual 
 * information associated with Key Events. 
 * <p>The <code>detail</code> attribute inherited from <code>UIEvent</code> is 
 * used to indicated the number of keypresses which have occurred during key 
 * repetition. If this information is not available this value should be 0.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Events-20000901'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface KeyEvent extends UIEvent {
    // VirtualKeyCode
    /**
     * Used for key events which do not have a virtual key code available.
     */
    public static final int DOM_VK_UNDEFINED          = 0x0;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_RIGHT_ALT          = 0x12;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_LEFT_ALT           = 0x12;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_LEFT_CONTROL       = 0x11;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_RIGHT_CONTROL      = 0x11;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_LEFT_SHIFT         = 0x10;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_RIGHT_SHIFT        = 0x10;
    /**
     * This key is modifier key
     */
    public static final int DOM_VK_META               = 0x9D;
    /**
     */
    public static final int DOM_VK_BACK_SPACE         = 0x08;
    /**
     */
    public static final int DOM_VK_CAPS_LOCK          = 0x14;
    /**
     */
    public static final int DOM_VK_DELETE             = 0x7F;
    /**
     */
    public static final int DOM_VK_END                = 0x23;
    /**
     */
    public static final int DOM_VK_ENTER              = 0x0D;
    /**
     */
    public static final int DOM_VK_ESCAPE             = 0x1B;
    /**
     */
    public static final int DOM_VK_HOME               = 0x24;
    /**
     */
    public static final int DOM_VK_NUM_LOCK           = 0x90;
    /**
     */
    public static final int DOM_VK_PAUSE              = 0x13;
    /**
     */
    public static final int DOM_VK_PRINTSCREEN        = 0x9A;
    /**
     */
    public static final int DOM_VK_SCROLL_LOCK        = 0x91;
    /**
     */
    public static final int DOM_VK_SPACE              = 0x20;
    /**
     */
    public static final int DOM_VK_TAB                = 0x09;
    /**
     */
    public static final int DOM_VK_LEFT               = 0x25;
    /**
     */
    public static final int DOM_VK_RIGHT              = 0x27;
    /**
     */
    public static final int DOM_VK_UP                 = 0x26;
    /**
     */
    public static final int DOM_VK_DOWN               = 0x28;
    /**
     */
    public static final int DOM_VK_PAGE_DOWN          = 0x22;
    /**
     */
    public static final int DOM_VK_PAGE_UP            = 0x21;
    /**
     * Constant for the F1 function key.
     */
    public static final int DOM_VK_F1                 = 0x70;
    /**
     * Constant for the F2 function key.
     */
    public static final int DOM_VK_F2                 = 0x71;
    /**
     * Constant for the F3 function key.
     */
    public static final int DOM_VK_F3                 = 0x72;
    /**
     * Constant for the F4 function key.
     */
    public static final int DOM_VK_F4                 = 0x73;
    /**
     * Constant for the F5 function key.
     */
    public static final int DOM_VK_F5                 = 0x74;
    /**
     * Constant for the F6 function key.
     */
    public static final int DOM_VK_F6                 = 0x75;
    /**
     * Constant for the F7 function key.
     */
    public static final int DOM_VK_F7                 = 0x76;
    /**
     * Constant for the F8 function key.
     */
    public static final int DOM_VK_F8                 = 0x77;
    /**
     * Constant for the F9 function key.
     */
    public static final int DOM_VK_F9                 = 0x78;
    /**
     * Constant for the F10 function key.
     */
    public static final int DOM_VK_F10                = 0x79;
    /**
     * Constant for the F11 function key.
     */
    public static final int DOM_VK_F11                = 0x7A;
    /**
     * Constant for the F12 function key.
     */
    public static final int DOM_VK_F12                = 0x7B;
    /**
     * Constant for the F13 function key.
     */
    public static final int DOM_VK_F13                = 0xF000;
    /**
     * Constant for the F14 function key.
     */
    public static final int DOM_VK_F14                = 0xF001;
    /**
     * Constant for the F15 function key.
     */
    public static final int DOM_VK_F15                = 0xF002;
    /**
     * Constant for the F16 function key.
     */
    public static final int DOM_VK_F16                = 0xF003;
    /**
     * Constant for the F17 function key.
     */
    public static final int DOM_VK_F17                = 0xF004;
    /**
     * Constant for the F18 function key.
     */
    public static final int DOM_VK_F18                = 0xF005;
    /**
     * Constant for the F19 function key.
     */
    public static final int DOM_VK_F19                = 0xF006;
    /**
     * Constant for the F20 function key.
     */
    public static final int DOM_VK_F20                = 0xF007;
    /**
     * Constant for the F21 function key.
     */
    public static final int DOM_VK_F21                = 0xF008;
    /**
     * Constant for the F22 function key.
     */
    public static final int DOM_VK_F22                = 0xF009;
    /**
     * Constant for the F23 function key.
     */
    public static final int DOM_VK_F23                = 0xF00A;
    /**
     * Constant for the F24 function key.
     */
    public static final int DOM_VK_F24                = 0xF00B;

    /**
     *  <code>outputString</code> holds the value of the output generated by 
     * the key event. This may be a single Unicode character or it may be a 
     * string. It may also be null in the case where no output was generated 
     * by the key event.
     */
    public String getOutputString();
    public void setOutputString(String outputString);

    /**
     *  The value of <code>keyVal</code> holds the value of the Unicode 
     * character associated with the depressed key. If the key has no 
     * Unicode representation or no Unicode character is available the value 
     * is 0.. 
     */
    public int getKeyVal();
    public void setKeyVal(int keyVal);

    /**
     * When the key associated with a key event is not representable via a 
     * Unicode character <code>virtKeyVale</code> holds the virtual key code 
     * associated with the depressed key. If the key has a Unicode 
     * representation or no virtual code is available the value is 
     * <code>DOM_VK_UNDEFINED</code>. 
     */
    public int getVirtKeyVal();
    public void setVirtKeyVal(int virtKeyVal);

    /**
     * The <code>inputGenerated</code> attribute indicates whether the key 
     * event will normally cause visible output. If the key event does not 
     * generate any visible output, such as the use of a function key or the 
     * combination of certain modifier keys used in conjunction with another 
     * key, then the value will be false. If visible output is normally 
     * generated by the key event then the value will be true. 
     * <br>The value of <code>inputGenerated</code> does not guarantee the 
     * creation of a character. If a key event causing visible output is 
     * cancelable it may be prevented from causing output. This attribute is 
     * intended primarily to differentiate between keys events which may or 
     * may not produce visible output depending on the system state.
     */
    public boolean getInputGenerated();
    public void setInputGenerated(boolean inputGenerated);

    /**
     * The <code>numPad</code> attribute indicates whether or not the key 
     * event was generated on the number pad section of the keyboard. If the 
     * number pad was used to generate the key event the value is true, 
     * otherwise the value is false.
     */
    public boolean getNumPad();
    public void setNumPad(boolean numPad);

    /**
     * The <code>GetModifier</code> method is used to check the status of a 
     * single modifier key associated with a <code>KeyEvent</code>. The 
     * identifier of the modifier in question is passed into the 
     * <code>GetModifier</code> function. If the modifier is triggered it 
     * will return true. If not, it will return false.
     * <br>The list of keys below represents the allowable modifier paramaters 
     * for this method.DOM_VK_LEFT_ALTDOM_VK_RIGHT_ALTDOM_VK_LEFT_CONTROL
     * DOM_VK_RIGHT_CONTROLDOM_VK_LEFT_SHIFTDOM_VK_RIGHT_SHIFTDOM_VK_META
     * @param modiferThe modifier which the user wishes to query
     * @return 
     */
    public boolean GetModifier(int modifer);

    /**why no modifiers parameter to the initKeyEvent?
     * @param typeArgSpecifies the event type.
     * @param canBubbleArgSpecifies whether or not the event can bubble.
     * @param cancelableArgSpecifies whether or not the event's default 
     *   action can be prevent.
     * @param viewArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>AbstractView</code>.
     * @param detailArgSpecifies the number of repeated keypresses, if 
     *   available.
     * @param outputStringArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>outputString</code> attribute
     * @param keyValArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>keyVal</code>attribute
     * @param virtKeyValArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>virtKeyVal</code>attribute
     * @param inputGeneratedArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>inputGenerated</code>attribute
     * @param numPadArgSpecifies the <code>KeyEvent</code>'s 
     *   <code>numPad</code>attribute
     */
    public void initKeyEvent(String typeArg, 
                             boolean canBubbleArg, 
                             boolean cancelableArg, 
                             AbstractView viewArg, 
                             short detailArg, 
                             String outputStringArg, 
                             int keyValArg, 
                             int virtKeyValArg, 
                             boolean inputGeneratedArg, 
                             boolean numPadArg);

}
