/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

/**
 * The EventGrouped interface is implemented by all Event objects.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Events-20000901'>Document Object Model (DOM) Level 3 Events Specification</a>.
 */
public interface EventGrouped {
    /**
     * The <code>stopPropagation</code> method is used prevent further 
     * propagation of an event during event flow within an 
     * <code>EventGroup</code>. If this method is called by any 
     * <code>EventListener</code> the event will cease propagating through 
     * the tree within the specified <code>EventGroup</code>. The event will 
     * complete dispatch to all listeners on the current 
     * <code>EventTarget</code> before event flow stops. This method may be 
     * used during any stage of event flow. Event propagation for other 
     * <code>EventGroup</code>s, or listeners not associated with any 
     * <code>EventGroup</code>, is not affected. 
     * @param eventGroup The <code>EventGroup</code> in which to stop event 
     *   propagation.
     */
    public void stopPropagation(EventGroup eventGroup);

}
