/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.events;

/**
 * The EventGroup interface is simply a placeholder for separating the event 
 * flows when there are multiple groups of listeners for a DOM tree.
 * <p>Event listeners can be registered without an <code>EventGroup</code> 
 * using the existing <code>EventTarget</code> interface, or with an 
 * associated <code>EventGroup</code> using the new 
 * <code>EventTargetGroup</code> interface. When an event is dispatched, it 
 * is dispatched independently to each <code>EventGroup</code>. In 
 * particular, the<code>stopPropagation</code> method of the 
 * <code>Event</code> interface only stops propagation for event listeners 
 * without an associated EventGroup. Correspondingly, the 
 * <code>stopPropagation</code> method of <code>EventGrouped</code> only 
 * stops propagatation for event listeners within the specified EventGroup.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Events-20000901'>Document Object Model (DOM) Level 3 Events Specification</a>.
 */
public interface EventGroup {
}
