/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom;

import org.w3c.Entity;

/**
 * This interface extends the <code>Entity</code> interface with additional 
 * attributes to provide information on the text declaration of external 
 * parsed entities.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-3-Core-20000901'>Document Object Model (DOM) Level 3 Core Specification</a>.
 */
public interface Entity3 extends Entity {
    /**
     * An attribute specifying the actual encoding of this entity, when it is 
     * an external parsed entity. This is <code>null</code> otherwise.
     */
    public String getActualEncoding();
    public void setActualEncoding(String actualEncoding);

    /**
     * An attribute specifying, as part of the text declaration, the encoding 
     * of this entity, when it is an external parsed entity. This is 
     * <code>null</code> otherwise.
     */
    public String getEncoding();
    public void setEncoding(String encoding);

    /**
     * An attribute specifying, as part of the text declaration, the version 
     * number of this entity, when it is an external parsed entity. This is 
     * <code>null</code> otherwise.
     */
    public String getVersion();
    public void setVersion(String version);

}
