/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom;

/**
 * The <code>DOMImplementation</code> interface provides a number of methods 
 * for performing operations that are independent of any particular instance 
 * of the document object model. 
 * <p>The DOM Level 1 does not specify a way of creating a document instance, 
 * and hence document creation is an operation specific to an 
 * implementation. Future Levels of the DOM specification are expected to 
 * provide methods for creating documents directly.
 * <p>See also the <a href='http://www.w3.org/TR/2000/WD-DOM-Level-1-20000929'>Document Object Model (DOM) Level 1 Specification (Second Edition)</a>.
 */
public interface DOMImplementation {
    /**
     * Test if the DOM implementation implements a specific feature.
     * @param featureThe name of the feature to test (case-insensitive). The 
     *   values used by DOM features are defined throughout this 
     *   specification and listed in the  section. The name must be an XML 
     *   name. To avoid possible conflicts, as a convention, names referring 
     *   to features defined outside the DOM specification should be made 
     *   unique by reversing the name of the Internet domain name of the 
     *   person (or the organization that the person belongs to) who defines 
     *   the feature, component by component, and using this as a prefix. 
     *   For instance, the W3C SYMM Working Group defines the feature 
     *   "org.w3c.dom.smil".
     * @param versionThis is the version number of the feature to test. In 
     *   Level 1, this is the string "1.0". If the version is not specified, 
     *   supporting any version of the feature causes the method to return 
     *   <code>true</code>.
     * @return <code>true</code> if the feature is implemented in the 
     *   specified version, <code>false</code> otherwise.
     */
    public boolean hasFeature(String feature, 
                              String version);

}
