<!-- ....................................................................... -->
<!-- MyML Qualified Names Template Module .................................. -->
<!-- file: template-qname-1.mod

     This is an extension of XHTML, a reformulation of HTML as 
     a modular XML application.

     The Extensible Hypertext Markup Language (XHTML)
     Copyright 1998-2000 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: template-qname-1.mod,v 1.2 2000/04/07 10:29:03 ahby Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ELEMENTS MyML Qualified Names Template 1.0//EN"
       SYSTEM "template-qname-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- NOTES:  Using the MyML Qualified Names Extension Template

     This is a template module for a fictious markup language 'MyML',
     which currently declares two extension element types, <front> 
     and <back>. The parameter entity naming convention uses uppercase 
     for the entity name and lowercase for namespace prefixes, hence 
     this example uses 'MYML' and 'myml' respectively. This template
     includes yet another fictitious markup language named 'MyOtherML'.

     This template scheme can accommodate the inclusion of more than
     one namespace by copying and modifying this template for each 
     included namespace, and recursively including each template's 
     aggregated declarations via the %MYOTHERML.xmlns.attrib; parameter 
     entity (these entities being renamed appropriate to each
     markup language's names). The most-embedded markup language is 
     declared first, with XLink grandfathered in that first template, 
     if it is used in the DTD.
     
     Please note the three case variants: 

         'MyML'   the human-readable markup language name
         'MYML'   used as a parameter entity name prefix 
         'myml'   used as the default namespace prefix

     To use this module as a template, replace the three names above
     with suitable ones for your language, modifying the template as
     necessary, then declare it as '%xhtml-qname-extra.mod;', prior 
     to where it is instantiated in Section A of the XHTML Qualified 
     Names module.

     The %NS.prefixed; conditional section keyword must be declared 
     as "INCLUDE" in order to allow prefixing be used.
-->
<!-- MyOtherML 

     This section is not part of the template, but is used to 
     simulate the previous namespace framework declarations of 
     a second fictitious vocabulary named 'MyOtherML', declared
     prior to this module.

     The accumulated template declarations may be integrated into 
     a single module, but their order in the DTD should remain 
     consistent.
-->
<!ENTITY % MYOTHERML.module "INCLUDE" >
<![%MYOTHERML.module;[
<!ENTITY % MYML.prefixed "%NS.prefixed;" >
<!ENTITY % MYOTHERML.xmlns "http://myotherml-namespace-uri" >
<!ENTITY % MYOTHERML.prefix "myoml" >
<![%MYML.prefixed;[
<!ENTITY % MYOTHERML.pfx  "%MYOTHERML.prefix;:" >
]]>
<!ENTITY % MYOTHERML.pfx "" >
<!ENTITY % MYOTHERML.xmlns.attrib 
     "xmlns:%MYOTHERML.prefix;  %URI.datatype;  #FIXED '%MYOTHERML.xmlns;'"
>
]]>

<!-- end of NOTES section -->


<!-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::: -->

<!-- MyML Qualified Names

     This module is contained in two parts, labeled Section 'A' and 'B':

       Section A declares parameter entities to support namespace-
       qualified names, namespace declarations, and name prefixing 
       for MyML.
    
       Section B declares parameter entities used to provide
       namespace-qualified names for all MyML element types.

     The recommended 12 step programme for creating conforming 
     modules is enumerated below, and spans both the MyML Qualified
     Names Template and MyML Extension Template modules.
-->

<!-- Section A: XHTML XML Namespace Framework :::::::::::::::::::: -->

<!-- 1. Declare the two parameter entities used to support XLink,
        first the parameter entity container for the URI used to
        identify the XLink namespace:
-->
<!ENTITY % XLINK.xmlns "http://www.w3.org/1999/xlink" >

<!-- This contains the XLink namespace declaration attribute.
-->
<!ENTITY % XLINK.xmlns.attrib
     "xmlns:xlink  %URI.datatype;           #FIXED '%XLINK.xmlns;'"
>

<!-- 2. Declare a parameter entity %MYML.xmlns; containing the 
        namespace URI for the MyML namespace:
-->
<!ENTITY % MYML.xmlns  "http://myml-namespace-uri" >

<!-- 3. Declare a parameter entity %MYML.prefix; containing the 
        default namespace prefix string(s) to use when prefixing 
        is enabled. This may be overridden in the DTD driver or 
        the internal subset of an document instance when prefixing 
        of only the non-XHTML markup is desired.

     NOTE: As specified in [XMLNAMES], the namespace prefix serves 
     as a proxy for the URI reference, and is not in itself significant.
-->
<!ENTITY % MYML.prefix  "myml" >

<!-- 4. Declare a %MYML.prefixed; conditional section keyword, used
        to activate namespace prefixing. The default value should 
        inherit '%NS.prefixed;' from the DTD driver, so that unless 
        overridden, the default behaviour follows the overall DTD 
        prefixing scheme.
-->
<!ENTITY % NS.prefixed "IGNORE" >
<!ENTITY % MYML.prefixed "%NS.prefixed;" >

<!-- 5. Declare a parameter entity %MYML.pfx; containing the 
        colonized prefix (eg., '%MYML.prefix;:') used when 
        prefixing is active, an empty string when it is not.
-->
<![%MYML.prefixed;[
<!ENTITY % MYML.pfx  "%MYML.prefix;:" >
]]>
<!ENTITY % MYML.pfx  "" >

<!-- 6. Declare a parameter entity %MYML.xmlns.extra.attrib;
        that when %MYML.prefixed; is 'INCLUDE' recursively 
        contains all non-MyML namespace declaration attributes 
        for namespaces embedded in MyML. 

        When %MYML.prefixed; is 'IGNORE', this should be declared
        as '%XLINK.xmlns.attrib;', or an empty string if XLink is 
        not used in the DTD. 
-->
<![%MYML.prefixed;[
<!ENTITY % MYOTHERML.xmlns.attrib "" >
<!ENTITY % MYML.xmlns.extra.attrib 
     "%MYOTHERML.xmlns.attrib;
      %XLINK.xmlns.attrib;"
>
]]>
<!ENTITY % MYML.xmlns.extra.attrib 
     "%XLINK.xmlns.attrib;"
>

<!-- 7. Declare a parameter entity %MYML.xmlns.attrib; containing 
        all XML namespace declaration attributes used by MyML, 
        the form dependent on whether prefixing is active. Neither
        XHTML nor XLink should be included here.
-->
<![%MYML.prefixed;[
<!ENTITY % MYML.xmlns.attrib
     "xmlns:%MYML.prefix;  %URI.datatype;   #FIXED '%MYML.xmlns;'
      %MYML.xmlns.extra.attrib;"
>
]]>
<!ENTITY % MYML.xmlns.attrib
     "xmlns        %URI.datatype;           #FIXED '%MYML.xmlns;'
      %MYML.xmlns.extra.attrib;"
>

<!-- 8. Declare a parameter entity that recursively aggregates all 
        previous namespace declaration attributes by including the 
        %MYML.xmlns.extra.attrib; parameter entity into that of its
        embedding vocabulary, in this case XHTML.

        NOTE: this conditional section is controlled by %NS.prefixed; 
        so that MyML's default namespace attribute won't appear on 
        XHTML elements when only MyML prefixing is active.
-->
<![%NS.prefixed;[
<!ENTITY % XHTML.xmlns.extra.attrib 
     "%MYML.xmlns.attrib;" >
]]>
<!ENTITY % XHTML.xmlns.extra.attrib
     "%XLINK.xmlns.attrib;"
>

<!-- Section B: MyML Qualified Names ::::::::::::::::::::::::::::: -->

<!-- 9. This section declares parameter entities used to provide
        namespace-qualified names for all MyML element types.
-->

<!-- template-1.mod -->
<!ENTITY % MYML.front.qname  "%MYML.pfx;front" >
<!ENTITY % MYML.back.qname   "%MYML.pfx;back" >

<!-- end of template-qname-1.mod -->
