<!-- ...................................................................... -->
<!-- MyML Extension Template Module ....................................... -->
<!-- file: template-1.mod

     This is an extension of XHTML, a reformulation of HTML as 
     a modular XML application.

     The Extensible Hypertext Markup Language (XHTML)
     Copyright 1998-2000 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: template-1.mod,v 1.2 2000/04/07 10:29:03 ahby Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ENTITIES MyML Extension Template 1.0//EN"
       SYSTEM "template-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Extension Template

     [This sample template module declares two extension element 
     types, <front> and <back>. The parameter entity naming 
     convention uses uppercase for the entity name and lowercase
     for namespace prefixes, hence this example uses 'MYML' and 
     'mod' respectively.]

     This module declares parameter entities used to provide
     namespace-qualified names for all MyML element types,
     as well as an extensible framework for attribute-based
     namespace declarations on all element types.

     The %NS.prefixed; conditional section keyword must be
     declared as "INCLUDE" in order to allow prefixing to be used.
     By default, foreign (i.e., non-XHTML) namespace modules should
     inherit %NS.prefixed; from XHTML, but this can be overridden
     when prefixing of only the non-XHTML markup is desired.

     XHTML's default value for the 'namespace prefix' is an empty
     string. The Prefix value can be redeclared either in a DTD
     driver or in a document's internal subset as appropriate.

     NOTE: As specified in [XMLNAMES], the namespace prefix serves as
     a proxy for the URI reference, and is not in itself significant.
-->

<!-- ......................................................................  -->

<!-- 10. Declare the xmlns attributes used by MYML dependent on whether
         MyML's prefixing is active. This should be used on all MyML
         element types as part of MyML's common attributes.

        If the entire DTD is namespace-prefixed, MyML should inherit 
        %NamespaceDecl.attrib;, otherwise it should declare default 
        xmlns attributes on its own element types.
-->
<![%NS.prefixed;[
<!ENTITY % MYML.NamespaceDecl.attrib "%NamespaceDecl.attrib;" >
]]>
<!ENTITY % MYML.NamespaceDecl.attrib "%MYML.xmlns.attrib;" >

<!-- now include the module's various markup declarations ........ -->

<!ENTITY % MYML.Common.attrib 
     "%MYML.NamespaceDecl.attrib;
      id           ID                       #IMPLIED"
>

<!-- 11. In the attribute list for each element, declare the XML Namespace
         declarations that are legal in the document instance by including
         the %NamespaceDecl.attrib; parameter entity in the ATTLIST of
         each element type.
-->

<!ENTITY % MYML.front.qname  "front" >
<!ELEMENT %MYML.front.qname;  ( %Flow.mix; )* >
<!ATTLIST %MYML.front.qname;
      %MYML.Common.attrib;
>

<!ENTITY % MYML.back.qname  "back" >
<!ELEMENT %MYML.back.qname;  ( %Flow.mix; )* >
<!ATTLIST %MYML.back.qname;
      %MYML.Common.attrib;
>

<!-- 12. If the module adds attributes to elements defined in modules that
         do not share the namespace of this module, declare those attributes
         so that they use the %MYML.pfx; prefix. For example:

         This would add an attribute to the img element of the Image Module, but
         the attribute's name will be the qualified name, including prefix, when
         prefixes are selected for a document instance.
-->
<!ENTITY % MYML.img.myattr.qname "%MYML.pfx;myattr" >
<!ATTLIST %img.qname;
      %MYML.img.myattr.qname;  CDATA      #IMPLIED
>

<!-- end of template-1.mod -->
