
package org.w3c.dom.svg;

public interface SVGTransform {
  // Transform Types
  public static final short SVG_TRANSFORM_UNKNOWN   = 0;
  public static final short SVG_TRANSFORM_MATRIX    = 1;
  public static final short SVG_TRANSFORM_TRANSLATE = 2;
  public static final short SVG_TRANSFORM_SCALE     = 3;
  public static final short SVG_TRANSFORM_ROTATE    = 4;
  public static final short SVG_TRANSFORM_SKEWX     = 5;
  public static final short SVG_TRANSFORM_SKEWY     = 6;

  public short getType( );
  public SVGMatrix getMatrix( );
  public SVGAngle getAngle( );

  void setMatrix ( SVGMatrix matrix )
                  throws SVGException;
  void setTranslate ( SVGLength tx, SVGLength ty )
                  throws SVGException;
  void setScale ( SVGNumber sx, SVGNumber sy )
                  throws SVGException;
  void setRotate ( SVGAngle angle )
                  throws SVGException;
  void setSkewX ( SVGAngle angle )
                  throws SVGException;
  void setSkewY ( SVGAngle angle )
                  throws SVGException;
}
