
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;
import org.w3c.dom.events.EventTarget;

public interface SVGTextContentElement extends SVGElement, SVGLangSpace, SVGTests, EventTarget {
  public String getClassName( );
  public void setClassName( String className );

  int      getNumberOfChars (  );
  float    getLength (  );
  float    getSubStringLength ( int charnum, int nchars )
                  throws DOMException, SVGException;
  SVGPoint getStartPositionOfChar ( int charnum )
                  throws DOMException;
  SVGPoint getEndPositionOfChar ( int charnum )
                  throws DOMException;
  SVGRect  getExtentOfChar ( int charnum )
                  throws DOMException;
  float    getRotationOfChar ( int charnum )
                  throws DOMException;
  int      getCharNumAtPosition ( SVGPoint point )
                  throws SVGException;
  void     selectSubString ( int charnum, int nchars )
                  throws DOMException;
}
