
package org.w3c.dom.svg;

import org.w3c.dom.events.EventTarget;

public interface SVGPathElement extends SVGElement, SVGTransformable, SVGLangSpace, SVGTests, EventTarget {
  public String getClassName( );
  public void      setClassName( String className );
  public SVGNumber getLength( );
  public void      setLength( SVGNumber length );
  public SVGList   getPathSegList( );
  public SVGList   getNormalizedPathSegList( );

  float         getTotalLength (  );
  SVGPoint      getPointAtLength ( float distance )
                  throws SVGException;
  int          getPathSegAtLength ( float distance )
                  throws SVGException;
  SVGPathSeg    createSVGPathSeg (  );
}
