
package org.w3c.dom.svg;

public interface SVGMarkerElement extends SVGElement, SVGLangSpace, SVGFitToViewBox {
  // Marker Unit Types
  public static final short SVG_MARKERUNITS_UNKNOWN        = 0;
  public static final short SVG_MARKERUNITS_USERSPACE      = 1;
  public static final short SVG_MARKERUNITS_USERSPACEONUSE = 2;
  public static final short SVG_MARKERUNITS_STROKEWIDTH    = 3;
  // Marker Orientation Types
  public static final short SVG_MARKER_ORIENT_UNKNOWN      = 0;
  public static final short SVG_MARKER_ORIENT_AUTO         = 1;
  public static final short SVG_MARKER_ORIENT_ANGLE        = 2;

  public String getClassName( );
  public void      setClassName( String className );
  public short getMarkerUnits( );
  public short getOrientType( );
  public SVGAngle getOrientAngle( );
  public SVGLength getRefX( );
  public void      setRefX( SVGLength refX );
  public SVGLength getRefY( );
  public void      setRefY( SVGLength refY );
  public SVGLength getMarkerWidth( );
  public void      setMarkerWidth( SVGLength markerWidth );
  public SVGLength getMarkerHeight( );
  public void      setMarkerHeight( SVGLength markerHeight );

  void setOrientToAuto (  );
  void setOrientToAngle ( SVGAngle angle )
                  throws SVGException;
}
