
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.EventTarget;

public interface SVGSVGElement extends SVGElement, SVGLangSpace, SVGTests, SVGFitToViewBox, DocumentEvent, EventTarget {
  public String getClassName( );
  public void      setClassName( String className );
  public SVGRect getViewport( );
  public float getCSSPixelToMillimeterX( );
  public float getCSSPixelToMillimeterY( );
  public float getScreenPixelToMillimeterX( );
  public float getScreenPixelToMillimeterY( );
  public boolean getUseCurrentView( );
  public void      setUseCurrentView( boolean useCurrentView );
  public SVGViewSpec getCurrentView( );
  public boolean getEnableZoomAndPanControls( );
  public void      setEnableZoomAndPanControls( boolean enableZoomAndPanControls );
  public float getCurrentScale( );
  public void      setCurrentScale( float currentScale );
  public SVGPoint getCurrentTranslate( );
  public void      setCurrentTranslate( SVGPoint currentTranslate );
  public SVGLength getX( );
  public void      setX( SVGLength x );
  public SVGLength getY( );
  public void      setY( SVGLength y );
  public SVGLength getWidth( );
  public void      setWidth( SVGLength width );
  public SVGLength getHeight( );
  public void      setHeight( SVGLength height );

  int          suspendRedraw ( int max_wait_milliseconds );
  void          unsuspendRedraw ( int suspend_handle_id )
                  throws DOMException;
  void          unsuspendRedrawAll (  );
  void          forceRedraw (  );
  void          pauseAnimations (  );
  void          unpauseAnimations (  );
  boolean       animationsPaused (  );
  float         getCurrentTime (  );
  void          setCurrentTime ( float seconds );
  NodeList      getIntersectionList ( SVGRect rect, SVGElement referenceElement )
                  throws SVGException;
  NodeList      getEnclosureList ( SVGRect rect, SVGElement referenceElement )
                  throws SVGException;
  boolean       checkIntersection ( SVGElement element, SVGRect rect )
                  throws SVGException;
  boolean       checkEnclosure ( SVGElement element, SVGRect rect )
                  throws SVGException;
  void          deSelectAll (  );
  SVGNumber              createSVGNumber (  );
  SVGLength              createSVGLength (  );
  SVGLengthList          createSVGLengthList (  );
  SVGAngle               createSVGAngle (  );
  SVGPoint               createSVGPoint (  );
  SVGPointList           createSVGPointList (  );
  SVGMatrix              createSVGMatrix (  );
  SVGPreserveAspectRatio createSVGPreserveAspectRatio (  );
  SVGRect                createSVGRect (  );
  SVGTransformList       createSVGTransformList (  );
  SVGTransformList createSVGTransformListFromMatrix ( SVGMatrix matrix );
  SVGTransform           createSVGTransform (  );
  SVGTransform     createSVGTransformFromMatrix ( SVGMatrix matrix );
  SVGICCColor              createSVGICCColor (  );
  SVGColor              createSVGColor (  );
  SVGPaint              createSVGPaint (  );
  Element         getElementById ( String elementId );
}
