
package org.w3c.dom.svg;

public interface SVGMatrix {
  public float      getA( );
  public void      setA( float a );
  public float      getB( );
  public void      setB( float b );
  public float      getC( );
  public void      setC( float c );
  public float      getD( );
  public void      setD( float d );
  public SVGLength getE( );
  public void      setE( SVGLength e );
  public SVGLength getF( );
  public void      setF( SVGLength f );

  SVGMatrix multiply ( SVGMatrix secondMatrix )
                  throws SVGException;
  SVGMatrix inverse (  )
                  throws SVGException;
  SVGMatrix translate ( SVGLength x, SVGLength y )
                  throws SVGException;
  SVGMatrix scale ( float scaleFactor )
                  throws SVGException;
  SVGMatrix scaleNonUniform ( float scaleFactorX, float scaleFactorY )
                  throws SVGException;
  SVGMatrix rotate ( SVGAngle angle )
                  throws SVGException;
  SVGMatrix rotateFromVector ( SVGLength x, SVGLength y )
                  throws SVGException;
  SVGMatrix flipX (  );
  SVGMatrix flipY (  );
  SVGMatrix skewX ( SVGAngle angle )
                  throws SVGException;
  SVGMatrix skewY ( SVGAngle angle )
                  throws SVGException;
}
