
package org.w3c.dom.svg;

import org.w3c.dom.css.RGBColor;

public interface SVGColor {
  // Color Types
  public static final short SVG_COLORTYPE_UNKNOWN           = 0;
  public static final short SVG_COLORTYPE_RGBCOLOR          = 1;
  public static final short SVG_COLORTYPE_RGBCOLOR_ICCCOLOR = 2;

  public short getColorType( );
  public RGBColor       getRGBColor( );
  public SVGICCColor    getICCColor( );
  public short getAnimatedColorType( );
  public RGBColor       getAnimatedRGBColor( );
  public SVGICCColor    getAnimatedICCColor( );

  void        setRGBColor ( RGBColor rgbColor )
                  throws SVGException;
  void        setRGBColorICCColor ( RGBColor rgbColor, SVGICCColor iccColor )
                  throws SVGException;
  RGBColor    createRGBColor (  );
  SVGICCColor createSVGICCColor (  );
}
